@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.ProviderIgnoreTagsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property keyPrefixes
 * @property keys
 */
public data class ProviderIgnoreTagsArgs(
    public val keyPrefixes: Output<List<String>>? = null,
    public val keys: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.ProviderIgnoreTagsArgs> {
    override fun toJava(): com.pulumi.aws.inputs.ProviderIgnoreTagsArgs =
        com.pulumi.aws.inputs.ProviderIgnoreTagsArgs.builder()
            .keyPrefixes(keyPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keys(keys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProviderIgnoreTagsArgs].
 */
@PulumiTagMarker
public class ProviderIgnoreTagsArgsBuilder internal constructor() {
    private var keyPrefixes: Output<List<String>>? = null

    private var keys: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("ykemrknreripfgxa")
    public suspend fun keyPrefixes(`value`: Output<List<String>>) {
        this.keyPrefixes = value
    }

    @JvmName("cuvxnxmfimwdgprx")
    public suspend fun keyPrefixes(vararg values: Output<String>) {
        this.keyPrefixes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pamqjdwynjcicxed")
    public suspend fun keyPrefixes(values: List<Output<String>>) {
        this.keyPrefixes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("vkkqqntgusgyqqvg")
    public suspend fun keys(`value`: Output<List<String>>) {
        this.keys = value
    }

    @JvmName("nncopbihcjlouybm")
    public suspend fun keys(vararg values: Output<String>) {
        this.keys = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rgamyguwvhwehbqi")
    public suspend fun keys(values: List<Output<String>>) {
        this.keys = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("nsaxmwsgkamdkvor")
    public suspend fun keyPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPrefixes = mapped
    }

    /**
     * @param values
     */
    @JvmName("vhdxvxqcoaaejwmt")
    public suspend fun keyPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyPrefixes = mapped
    }

    /**
     * @param value
     */
    @JvmName("gcmocgqhfdptpjck")
    public suspend fun keys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param values
     */
    @JvmName("wnxquxkqjepfiwim")
    public suspend fun keys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    internal fun build(): ProviderIgnoreTagsArgs = ProviderIgnoreTagsArgs(
        keyPrefixes = keyPrefixes,
        keys = keys,
    )
}
