@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getBillingServiceAccount.
 * @property arn ARN of the AWS billing service account.
 * @property id ID of the AWS billing service account.
 */
public data class GetBillingServiceAccountResult(
    public val arn: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetBillingServiceAccountResult):
            GetBillingServiceAccountResult = GetBillingServiceAccountResult(
            arn = javaType.arn(),
            id = javaType.id(),
        )
    }
}
