@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getCallerIdentity.
 * @property accountId AWS Account ID number of the account that owns or contains the calling entity.
 * @property arn ARN associated with the calling entity.
 * @property id Account ID number of the account that owns or contains the calling entity.
 * @property userId Unique identifier of the calling entity.
 */
public data class GetCallerIdentityResult(
    public val accountId: String,
    public val arn: String,
    public val id: String,
    public val userId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetCallerIdentityResult):
            GetCallerIdentityResult = GetCallerIdentityResult(
            accountId = javaType.accountId(),
            arn = javaType.arn(),
            id = javaType.id(),
            userId = javaType.userId(),
        )
    }
}
