@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getDefaultTags.
 * @property id
 * @property tags Blocks of default tags set on the provider. See details below.
 */
public data class GetDefaultTagsResult(
    public val id: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetDefaultTagsResult): GetDefaultTagsResult =
            GetDefaultTagsResult(
                id = javaType.id(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
