@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getRegion.
 * @property description Region's description in this format: "Location (Region name)".
 * @property endpoint EC2 endpoint for the selected region.
 * @property id
 * @property name Name of the selected region.
 */
public data class GetRegionResult(
    public val description: String,
    public val endpoint: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetRegionResult): GetRegionResult =
            GetRegionResult(
                description = javaType.description(),
                endpoint = javaType.endpoint(),
                id = javaType.id(),
                name = javaType.name(),
            )
    }
}
