@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRegions.
 * @property allRegions
 * @property filters
 * @property id Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
 * @property names Names of regions that meets the criteria.
 */
public data class GetRegionsResult(
    public val allRegions: Boolean? = null,
    public val filters: List<GetRegionsFilter>? = null,
    public val id: String,
    public val names: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetRegionsResult): GetRegionsResult =
            GetRegionsResult(
                allRegions = javaType.allRegions().map({ args0 -> args0 }).orElse(null),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kotlin.outputs.GetRegionsFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                names = javaType.names().map({ args0 -> args0 }),
            )
    }
}
