@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getService.
 * @property dnsName
 * @property id
 * @property partition
 * @property region
 * @property reverseDnsName
 * @property reverseDnsPrefix
 * @property serviceId
 * @property supported Whether the service is supported in the region's partition. New services may not be listed immediately as supported.
 */
public data class GetServiceResult(
    public val dnsName: String,
    public val id: String,
    public val partition: String,
    public val region: String,
    public val reverseDnsName: String,
    public val reverseDnsPrefix: String,
    public val serviceId: String,
    public val supported: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outputs.GetServiceResult): GetServiceResult =
            GetServiceResult(
                dnsName = javaType.dnsName(),
                id = javaType.id(),
                partition = javaType.partition(),
                region = javaType.region(),
                reverseDnsName = javaType.reverseDnsName(),
                reverseDnsPrefix = javaType.reverseDnsPrefix(),
                serviceId = javaType.serviceId(),
                supported = javaType.supported(),
            )
    }
}
