@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.kotlin.outputs.DataLakeSettingsCreateDatabaseDefaultPermission
import com.pulumi.aws.lakeformation.kotlin.outputs.DataLakeSettingsCreateTableDefaultPermission
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.lakeformation.kotlin.outputs.DataLakeSettingsCreateDatabaseDefaultPermission.Companion.toKotlin as dataLakeSettingsCreateDatabaseDefaultPermissionToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.DataLakeSettingsCreateTableDefaultPermission.Companion.toKotlin as dataLakeSettingsCreateTableDefaultPermissionToKotlin

/**
 * Builder for [DataLakeSettings].
 */
@PulumiTagMarker
public class DataLakeSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataLakeSettingsArgs = DataLakeSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataLakeSettingsArgsBuilder.() -> Unit) {
        val builder = DataLakeSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataLakeSettings {
        val builtJavaResource = com.pulumi.aws.lakeformation.DataLakeSettings(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataLakeSettings(builtJavaResource)
    }
}

/**
 * Manages Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.
 * > **NOTE:** Lake Formation introduces fine-grained access control for data in your data lake. Part of the changes include the `IAMAllowedPrincipals` principal in order to make Lake Formation backwards compatible with existing IAM and Glue permissions. For more information, see [Changing the Default Security Settings for Your Data Lake](https://docs&#46;aws&#46;amazon&#46;com/lake-formation/latest/dg/change-settings&#46;html) and [Upgrading AWS Glue Data Permissions to the AWS Lake Formation Model](https://docs.aws.amazon.com/lake-formation/latest/dg/upgrade-glue-lake-formation.html).
 * ## Example Usage
 * ### Data Lake Admins
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings("example", DataLakeSettingsArgs.builder()
 *             .admins(
 *                 aws_iam_user.test().arn(),
 *                 aws_iam_role.test().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Default Permissions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateTableDefaultPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings("example", DataLakeSettingsArgs.builder()
 *             .admins(
 *                 aws_iam_user.test().arn(),
 *                 aws_iam_role.test().arn())
 *             .createDatabaseDefaultPermissions(DataLakeSettingsCreateDatabaseDefaultPermissionArgs.builder()
 *                 .permissions(
 *                     "SELECT",
 *                     "ALTER",
 *                     "DROP")
 *                 .principal(aws_iam_user.test().arn())
 *                 .build())
 *             .createTableDefaultPermissions(DataLakeSettingsCreateTableDefaultPermissionArgs.builder()
 *                 .permissions("ALL")
 *                 .principal(aws_iam_role.test().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Enable EMR access to LakeFormation resources
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateTableDefaultPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings("example", DataLakeSettingsArgs.builder()
 *             .admins(
 *                 aws_iam_user.test().arn(),
 *                 aws_iam_role.test().arn())
 *             .createDatabaseDefaultPermissions(DataLakeSettingsCreateDatabaseDefaultPermissionArgs.builder()
 *                 .permissions(
 *                     "SELECT",
 *                     "ALTER",
 *                     "DROP")
 *                 .principal(aws_iam_user.test().arn())
 *                 .build())
 *             .createTableDefaultPermissions(DataLakeSettingsCreateTableDefaultPermissionArgs.builder()
 *                 .permissions("ALL")
 *                 .principal(aws_iam_role.test().arn())
 *                 .build())
 *             .allowExternalDataFiltering(true)
 *             .externalDataFilteringAllowLists(
 *                 data.aws_caller_identity().current().account_id(),
 *                 data.aws_caller_identity().third_party().account_id())
 *             .authorizedSessionTagValueLists("Amazon EMR")
 *             .build());
 *     }
 * }
 * ```
 */
public class DataLakeSettings internal constructor(
    override val javaResource: com.pulumi.aws.lakeformation.DataLakeSettings,
) : KotlinCustomResource(javaResource, DataLakeSettingsMapper) {
    /**
     * Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     */
    public val admins: Output<List<String>>
        get() = javaResource.admins().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
     */
    public val allowExternalDataFiltering: Output<Boolean>?
        get() = javaResource.allowExternalDataFiltering().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     * > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
     */
    public val authorizedSessionTagValueLists: Output<List<String>>
        get() = javaResource.authorizedSessionTagValueLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Identifier for the Data Catalog. By default, the account ID.
     */
    public val catalogId: Output<String>?
        get() = javaResource.catalogId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    public val createDatabaseDefaultPermissions:
        Output<List<DataLakeSettingsCreateDatabaseDefaultPermission>>
        get() = javaResource.createDatabaseDefaultPermissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataLakeSettingsCreateDatabaseDefaultPermissionToKotlin(args0) })
            })
        })

    /**
     * Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    public val createTableDefaultPermissions:
        Output<List<DataLakeSettingsCreateTableDefaultPermission>>
        get() = javaResource.createTableDefaultPermissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataLakeSettingsCreateTableDefaultPermissionToKotlin(args0) })
            })
        })

    /**
     * A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     */
    public val externalDataFilteringAllowLists: Output<List<String>>
        get() = javaResource.externalDataFilteringAllowLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     */
    public val readOnlyAdmins: Output<List<String>>
        get() = javaResource.readOnlyAdmins().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
     */
    public val trustedResourceOwners: Output<List<String>>
        get() = javaResource.trustedResourceOwners().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object DataLakeSettingsMapper : ResourceMapper<DataLakeSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lakeformation.DataLakeSettings::class == javaResource::class

    override fun map(javaResource: Resource): DataLakeSettings = DataLakeSettings(
        javaResource as
            com.pulumi.aws.lakeformation.DataLakeSettings,
    )
}

/**
 * @see [DataLakeSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataLakeSettings].
 */
public suspend fun dataLakeSettings(
    name: String,
    block: suspend DataLakeSettingsResourceBuilder.() -> Unit,
): DataLakeSettings {
    val builder = DataLakeSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataLakeSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataLakeSettings(name: String): DataLakeSettings {
    val builder = DataLakeSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
