@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.DataLakeSettingsArgs.builder
import com.pulumi.aws.lakeformation.kotlin.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.DataLakeSettingsCreateTableDefaultPermissionArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.DataLakeSettingsCreateTableDefaultPermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.
 * > **NOTE:** Lake Formation introduces fine-grained access control for data in your data lake. Part of the changes include the `IAMAllowedPrincipals` principal in order to make Lake Formation backwards compatible with existing IAM and Glue permissions. For more information, see [Changing the Default Security Settings for Your Data Lake](https://docs&#46;aws&#46;amazon&#46;com/lake-formation/latest/dg/change-settings&#46;html) and [Upgrading AWS Glue Data Permissions to the AWS Lake Formation Model](https://docs.aws.amazon.com/lake-formation/latest/dg/upgrade-glue-lake-formation.html).
 * ## Example Usage
 * ### Data Lake Admins
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings("example", DataLakeSettingsArgs.builder()
 *             .admins(
 *                 aws_iam_user.test().arn(),
 *                 aws_iam_role.test().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Default Permissions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateTableDefaultPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings("example", DataLakeSettingsArgs.builder()
 *             .admins(
 *                 aws_iam_user.test().arn(),
 *                 aws_iam_role.test().arn())
 *             .createDatabaseDefaultPermissions(DataLakeSettingsCreateDatabaseDefaultPermissionArgs.builder()
 *                 .permissions(
 *                     "SELECT",
 *                     "ALTER",
 *                     "DROP")
 *                 .principal(aws_iam_user.test().arn())
 *                 .build())
 *             .createTableDefaultPermissions(DataLakeSettingsCreateTableDefaultPermissionArgs.builder()
 *                 .permissions("ALL")
 *                 .principal(aws_iam_role.test().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Enable EMR access to LakeFormation resources
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.DataLakeSettings;
 * import com.pulumi.aws.lakeformation.DataLakeSettingsArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateDatabaseDefaultPermissionArgs;
 * import com.pulumi.aws.lakeformation.inputs.DataLakeSettingsCreateTableDefaultPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataLakeSettings("example", DataLakeSettingsArgs.builder()
 *             .admins(
 *                 aws_iam_user.test().arn(),
 *                 aws_iam_role.test().arn())
 *             .createDatabaseDefaultPermissions(DataLakeSettingsCreateDatabaseDefaultPermissionArgs.builder()
 *                 .permissions(
 *                     "SELECT",
 *                     "ALTER",
 *                     "DROP")
 *                 .principal(aws_iam_user.test().arn())
 *                 .build())
 *             .createTableDefaultPermissions(DataLakeSettingsCreateTableDefaultPermissionArgs.builder()
 *                 .permissions("ALL")
 *                 .principal(aws_iam_role.test().arn())
 *                 .build())
 *             .allowExternalDataFiltering(true)
 *             .externalDataFilteringAllowLists(
 *                 data.aws_caller_identity().current().account_id(),
 *                 data.aws_caller_identity().third_party().account_id())
 *             .authorizedSessionTagValueLists("Amazon EMR")
 *             .build());
 *     }
 * }
 * ```
 * @property admins Set of ARNs of AWS Lake Formation principals (IAM users or roles).
 * @property allowExternalDataFiltering Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
 * @property authorizedSessionTagValueLists Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
 * > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
 * @property catalogId Identifier for the Data Catalog. By default, the account ID.
 * @property createDatabaseDefaultPermissions Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
 * @property createTableDefaultPermissions Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
 * @property externalDataFilteringAllowLists A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
 * @property readOnlyAdmins Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
 * @property trustedResourceOwners List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
 */
public data class DataLakeSettingsArgs(
    public val admins: Output<List<String>>? = null,
    public val allowExternalDataFiltering: Output<Boolean>? = null,
    public val authorizedSessionTagValueLists: Output<List<String>>? = null,
    public val catalogId: Output<String>? = null,
    public val createDatabaseDefaultPermissions:
    Output<List<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>>? = null,
    public val createTableDefaultPermissions:
    Output<List<DataLakeSettingsCreateTableDefaultPermissionArgs>>? = null,
    public val externalDataFilteringAllowLists: Output<List<String>>? = null,
    public val readOnlyAdmins: Output<List<String>>? = null,
    public val trustedResourceOwners: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.DataLakeSettingsArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.DataLakeSettingsArgs =
        com.pulumi.aws.lakeformation.DataLakeSettingsArgs.builder()
            .admins(admins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowExternalDataFiltering(allowExternalDataFiltering?.applyValue({ args0 -> args0 }))
            .authorizedSessionTagValueLists(
                authorizedSessionTagValueLists?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .createDatabaseDefaultPermissions(
                createDatabaseDefaultPermissions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .createTableDefaultPermissions(
                createTableDefaultPermissions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .externalDataFilteringAllowLists(
                externalDataFilteringAllowLists?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .readOnlyAdmins(readOnlyAdmins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .trustedResourceOwners(
                trustedResourceOwners?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DataLakeSettingsArgs].
 */
@PulumiTagMarker
public class DataLakeSettingsArgsBuilder internal constructor() {
    private var admins: Output<List<String>>? = null

    private var allowExternalDataFiltering: Output<Boolean>? = null

    private var authorizedSessionTagValueLists: Output<List<String>>? = null

    private var catalogId: Output<String>? = null

    private var createDatabaseDefaultPermissions:
        Output<List<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>>? = null

    private var createTableDefaultPermissions:
        Output<List<DataLakeSettingsCreateTableDefaultPermissionArgs>>? = null

    private var externalDataFilteringAllowLists: Output<List<String>>? = null

    private var readOnlyAdmins: Output<List<String>>? = null

    private var trustedResourceOwners: Output<List<String>>? = null

    /**
     * @param value Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     */
    @JvmName("jgdxxqxbvegknuxx")
    public suspend fun admins(`value`: Output<List<String>>) {
        this.admins = value
    }

    @JvmName("yqwoxolxmosxbxoe")
    public suspend fun admins(vararg values: Output<String>) {
        this.admins = Output.all(values.asList())
    }

    /**
     * @param values Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     */
    @JvmName("rkufdhwjfsgwvtqg")
    public suspend fun admins(values: List<Output<String>>) {
        this.admins = Output.all(values)
    }

    /**
     * @param value Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
     */
    @JvmName("xycxylyvxrudnjlt")
    public suspend fun allowExternalDataFiltering(`value`: Output<Boolean>) {
        this.allowExternalDataFiltering = value
    }

    /**
     * @param value Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     * > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
     */
    @JvmName("phscwxlxidkwbtbj")
    public suspend fun authorizedSessionTagValueLists(`value`: Output<List<String>>) {
        this.authorizedSessionTagValueLists = value
    }

    @JvmName("muuyfvoynuntojpe")
    public suspend fun authorizedSessionTagValueLists(vararg values: Output<String>) {
        this.authorizedSessionTagValueLists = Output.all(values.asList())
    }

    /**
     * @param values Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     * > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
     */
    @JvmName("ocotxctndlufwdys")
    public suspend fun authorizedSessionTagValueLists(values: List<Output<String>>) {
        this.authorizedSessionTagValueLists = Output.all(values)
    }

    /**
     * @param value Identifier for the Data Catalog. By default, the account ID.
     */
    @JvmName("awpjgcqbjfbqefue")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("cjjoywpeioafceyn")
    public suspend
    fun createDatabaseDefaultPermissions(`value`: Output<List<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>>) {
        this.createDatabaseDefaultPermissions = value
    }

    @JvmName("rhfmmuotcghvaxyi")
    public suspend fun createDatabaseDefaultPermissions(
        vararg
        values: Output<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>,
    ) {
        this.createDatabaseDefaultPermissions = Output.all(values.asList())
    }

    /**
     * @param values Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("wyhraykhxxqjlrvi")
    public suspend
    fun createDatabaseDefaultPermissions(values: List<Output<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>>) {
        this.createDatabaseDefaultPermissions = Output.all(values)
    }

    /**
     * @param value Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("ycojfuarmeiwpkww")
    public suspend
    fun createTableDefaultPermissions(`value`: Output<List<DataLakeSettingsCreateTableDefaultPermissionArgs>>) {
        this.createTableDefaultPermissions = value
    }

    @JvmName("vqfxnvxmkkgnstwi")
    public suspend fun createTableDefaultPermissions(
        vararg
        values: Output<DataLakeSettingsCreateTableDefaultPermissionArgs>,
    ) {
        this.createTableDefaultPermissions = Output.all(values.asList())
    }

    /**
     * @param values Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("eevguctplvlrohyw")
    public suspend
    fun createTableDefaultPermissions(values: List<Output<DataLakeSettingsCreateTableDefaultPermissionArgs>>) {
        this.createTableDefaultPermissions = Output.all(values)
    }

    /**
     * @param value A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     */
    @JvmName("baklicblfystdbbk")
    public suspend fun externalDataFilteringAllowLists(`value`: Output<List<String>>) {
        this.externalDataFilteringAllowLists = value
    }

    @JvmName("qxmtkxpkmeutqoqo")
    public suspend fun externalDataFilteringAllowLists(vararg values: Output<String>) {
        this.externalDataFilteringAllowLists = Output.all(values.asList())
    }

    /**
     * @param values A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     */
    @JvmName("qjvwfudraildbkmb")
    public suspend fun externalDataFilteringAllowLists(values: List<Output<String>>) {
        this.externalDataFilteringAllowLists = Output.all(values)
    }

    /**
     * @param value Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     */
    @JvmName("hwwiqrgrnhpudwsj")
    public suspend fun readOnlyAdmins(`value`: Output<List<String>>) {
        this.readOnlyAdmins = value
    }

    @JvmName("wmdhwwxftddxkonc")
    public suspend fun readOnlyAdmins(vararg values: Output<String>) {
        this.readOnlyAdmins = Output.all(values.asList())
    }

    /**
     * @param values Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     */
    @JvmName("ekyxavlywofjtxgh")
    public suspend fun readOnlyAdmins(values: List<Output<String>>) {
        this.readOnlyAdmins = Output.all(values)
    }

    /**
     * @param value List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
     */
    @JvmName("xkvuxfgaunaawauj")
    public suspend fun trustedResourceOwners(`value`: Output<List<String>>) {
        this.trustedResourceOwners = value
    }

    @JvmName("qnndmopmcaenwmqr")
    public suspend fun trustedResourceOwners(vararg values: Output<String>) {
        this.trustedResourceOwners = Output.all(values.asList())
    }

    /**
     * @param values List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
     */
    @JvmName("uykffllntsvehjtc")
    public suspend fun trustedResourceOwners(values: List<Output<String>>) {
        this.trustedResourceOwners = Output.all(values)
    }

    /**
     * @param value Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     */
    @JvmName("aivannjusfvivtpd")
    public suspend fun admins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.admins = mapped
    }

    /**
     * @param values Set of ARNs of AWS Lake Formation principals (IAM users or roles).
     */
    @JvmName("ncnoqkadffxewgsj")
    public suspend fun admins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.admins = mapped
    }

    /**
     * @param value Whether to allow Amazon EMR clusters to access data managed by Lake Formation.
     */
    @JvmName("nckgnihvlusptanj")
    public suspend fun allowExternalDataFiltering(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowExternalDataFiltering = mapped
    }

    /**
     * @param value Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     * > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
     */
    @JvmName("bgcciufwwvduehws")
    public suspend fun authorizedSessionTagValueLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizedSessionTagValueLists = mapped
    }

    /**
     * @param values Lake Formation relies on a privileged process secured by Amazon EMR or the third party integrator to tag the user's role while assuming it.
     * > **NOTE:** Although optional, not including `admins`, `create_database_default_permissions`, `create_table_default_permissions`, and/or `trusted_resource_owners` results in the setting being cleared.
     */
    @JvmName("nhreaapqfmrymywx")
    public suspend fun authorizedSessionTagValueLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizedSessionTagValueLists = mapped
    }

    /**
     * @param value Identifier for the Data Catalog. By default, the account ID.
     */
    @JvmName("cireagucjdkmwkbt")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("iqtyntmkjxdesnyb")
    public suspend
    fun createDatabaseDefaultPermissions(`value`: List<DataLakeSettingsCreateDatabaseDefaultPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createDatabaseDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("mbrodplqhuprwiwr")
    public suspend
    fun createDatabaseDefaultPermissions(argument: List<suspend DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createDatabaseDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("mqnwasvgboscoocn")
    public suspend fun createDatabaseDefaultPermissions(
        vararg
        argument: suspend DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createDatabaseDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("ntjbwehbxftwvnrn")
    public suspend
    fun createDatabaseDefaultPermissions(argument: suspend DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DataLakeSettingsCreateDatabaseDefaultPermissionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.createDatabaseDefaultPermissions = mapped
    }

    /**
     * @param values Up to three configuration blocks of principal permissions for default create database permissions. Detailed below.
     */
    @JvmName("kvxnmkbohnmjjtkk")
    public suspend fun createDatabaseDefaultPermissions(
        vararg
        values: DataLakeSettingsCreateDatabaseDefaultPermissionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createDatabaseDefaultPermissions = mapped
    }

    /**
     * @param value Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("oaslpeqmtwbetsrf")
    public suspend
    fun createTableDefaultPermissions(`value`: List<DataLakeSettingsCreateTableDefaultPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("vcmktvmxsmfevwgj")
    public suspend
    fun createTableDefaultPermissions(argument: List<suspend DataLakeSettingsCreateTableDefaultPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataLakeSettingsCreateTableDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("ycbnxbshwkeedfub")
    public suspend fun createTableDefaultPermissions(
        vararg
        argument: suspend DataLakeSettingsCreateTableDefaultPermissionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataLakeSettingsCreateTableDefaultPermissionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param argument Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("plwewonguqxsibyf")
    public suspend
    fun createTableDefaultPermissions(argument: suspend DataLakeSettingsCreateTableDefaultPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataLakeSettingsCreateTableDefaultPermissionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param values Up to three configuration blocks of principal permissions for default create table permissions. Detailed below.
     */
    @JvmName("ymugkdxfrdwqkquo")
    public suspend fun createTableDefaultPermissions(
        vararg
        values: DataLakeSettingsCreateTableDefaultPermissionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createTableDefaultPermissions = mapped
    }

    /**
     * @param value A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     */
    @JvmName("srxuhfvrtnuudnjp")
    public suspend fun externalDataFilteringAllowLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalDataFilteringAllowLists = mapped
    }

    /**
     * @param values A list of the account IDs of Amazon Web Services accounts with Amazon EMR clusters that are to perform data filtering.
     */
    @JvmName("hsxhrxojdehqctvv")
    public suspend fun externalDataFilteringAllowLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalDataFilteringAllowLists = mapped
    }

    /**
     * @param value Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     */
    @JvmName("qtyfbjluwyuxibld")
    public suspend fun readOnlyAdmins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnlyAdmins = mapped
    }

    /**
     * @param values Set of ARNs of AWS Lake Formation principals (IAM users or roles) with only view access to the resources.
     */
    @JvmName("augpgwtmwkkhkpgm")
    public suspend fun readOnlyAdmins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readOnlyAdmins = mapped
    }

    /**
     * @param value List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
     */
    @JvmName("doxqmtsbkeuekvek")
    public suspend fun trustedResourceOwners(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedResourceOwners = mapped
    }

    /**
     * @param values List of the resource-owning account IDs that the caller's account can use to share their user access details (user ARNs).
     */
    @JvmName("oqoxxwofrebeidcd")
    public suspend fun trustedResourceOwners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedResourceOwners = mapped
    }

    internal fun build(): DataLakeSettingsArgs = DataLakeSettingsArgs(
        admins = admins,
        allowExternalDataFiltering = allowExternalDataFiltering,
        authorizedSessionTagValueLists = authorizedSessionTagValueLists,
        catalogId = catalogId,
        createDatabaseDefaultPermissions = createDatabaseDefaultPermissions,
        createTableDefaultPermissions = createTableDefaultPermissions,
        externalDataFilteringAllowLists = externalDataFilteringAllowLists,
        readOnlyAdmins = readOnlyAdmins,
        trustedResourceOwners = trustedResourceOwners,
    )
}
