@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.LakeformationFunctions.getDataLakeSettingsPlain
import com.pulumi.aws.lakeformation.LakeformationFunctions.getPermissionsPlain
import com.pulumi.aws.lakeformation.LakeformationFunctions.getResourcePlain
import com.pulumi.aws.lakeformation.kotlin.inputs.GetDataLakeSettingsPlainArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.GetDataLakeSettingsPlainArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsDataLocation
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsDatabase
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsLfTag
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsLfTagPolicy
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsPlainArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsPlainArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsTable
import com.pulumi.aws.lakeformation.kotlin.inputs.GetPermissionsTableWithColumns
import com.pulumi.aws.lakeformation.kotlin.inputs.GetResourcePlainArgs
import com.pulumi.aws.lakeformation.kotlin.inputs.GetResourcePlainArgsBuilder
import com.pulumi.aws.lakeformation.kotlin.outputs.GetDataLakeSettingsResult
import com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsResult
import com.pulumi.aws.lakeformation.kotlin.outputs.GetResourceResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.lakeformation.kotlin.outputs.GetDataLakeSettingsResult.Companion.toKotlin as getDataLakeSettingsResultToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.GetPermissionsResult.Companion.toKotlin as getPermissionsResultToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.GetResourceResult.Companion.toKotlin as getResourceResultToKotlin

public object LakeformationFunctions {
    /**
     * Get Lake Formation principals designated as data lake administrators and lists of principal permission entries for default create database and default create table permissions.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lakeformation.LakeformationFunctions;
     * import com.pulumi.aws.lakeformation.inputs.GetDataLakeSettingsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LakeformationFunctions.getDataLakeSettings(GetDataLakeSettingsArgs.builder()
     *             .catalogId("14916253649")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDataLakeSettings.
     * @return A collection of values returned by getDataLakeSettings.
     */
    public suspend fun getDataLakeSettings(argument: GetDataLakeSettingsPlainArgs):
        GetDataLakeSettingsResult =
        getDataLakeSettingsResultToKotlin(getDataLakeSettingsPlain(argument.toJava()).await())

    /**
     * @see [getDataLakeSettings].
     * @param catalogId Identifier for the Data Catalog. By default, the account ID.
     * @return A collection of values returned by getDataLakeSettings.
     */
    public suspend fun getDataLakeSettings(catalogId: String? = null): GetDataLakeSettingsResult {
        val argument = GetDataLakeSettingsPlainArgs(
            catalogId = catalogId,
        )
        return getDataLakeSettingsResultToKotlin(getDataLakeSettingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataLakeSettings].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lakeformation&#46;kotlin&#46;inputs&#46;GetDataLakeSettingsPlainArgs].
     * @return A collection of values returned by getDataLakeSettings.
     */
    public suspend
    fun getDataLakeSettings(argument: suspend GetDataLakeSettingsPlainArgsBuilder.() -> Unit):
        GetDataLakeSettingsResult {
        val builder = GetDataLakeSettingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataLakeSettingsResultToKotlin(getDataLakeSettingsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get permissions for a principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Permissions are granted to a principal, in a Data Catalog, relative to a Lake Formation resource, which includes the Data Catalog, databases, tables, LF-tags, and LF-tag policies. For more information, see [Security and Access Control to Metadata and Data in Lake Formation](https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).
     * > **NOTE:** This data source deals with explicitly granted permissions. Lake Formation grants implicit permissions to data lake administrators, database creators, and table creators. For more information, see [Implicit Lake Formation Permissions](https://docs.aws.amazon.com/lake-formation/latest/dg/implicit-permissions.html).
     * ## Example Usage
     * ### Permissions For A Lake Formation S3 Resource
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lakeformation.LakeformationFunctions;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsArgs;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsDataLocationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = LakeformationFunctions.getPermissions(GetPermissionsArgs.builder()
     *             .principal(aws_iam_role.workflow_role().arn())
     *             .dataLocation(GetPermissionsDataLocationArgs.builder()
     *                 .arn(aws_lakeformation_resource.test().arn())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### Permissions For A Glue Catalog Database
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lakeformation.LakeformationFunctions;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsArgs;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsDatabaseArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = LakeformationFunctions.getPermissions(GetPermissionsArgs.builder()
     *             .principal(aws_iam_role.workflow_role().arn())
     *             .database(GetPermissionsDatabaseArgs.builder()
     *                 .name(aws_glue_catalog_database.test().name())
     *                 .catalogId("110376042874")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### Permissions For Tag-Based Access Control
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lakeformation.LakeformationFunctions;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsArgs;
     * import com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTagPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = LakeformationFunctions.getPermissions(GetPermissionsArgs.builder()
     *             .principal(aws_iam_role.workflow_role().arn())
     *             .lfTagPolicy(GetPermissionsLfTagPolicyArgs.builder()
     *                 .resourceType("DATABASE")
     *                 .expressions(
     *                     GetPermissionsLfTagPolicyExpressionArgs.builder()
     *                         .key("Team")
     *                         .values("Sales")
     *                         .build(),
     *                     GetPermissionsLfTagPolicyExpressionArgs.builder()
     *                         .key("Environment")
     *                         .values(
     *                             "Dev",
     *                             "Production")
     *                         .build())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPermissions.
     * @return A collection of values returned by getPermissions.
     */
    public suspend fun getPermissions(argument: GetPermissionsPlainArgs): GetPermissionsResult =
        getPermissionsResultToKotlin(getPermissionsPlain(argument.toJava()).await())

    /**
     * @see [getPermissions].
     * @param catalogId Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     * @param catalogResource Whether the permissions are to be granted for the Data Catalog. Defaults to `false`.
     * @param dataLocation Configuration block for a data location resource. Detailed below.
     * @param database Configuration block for a database resource. Detailed below.
     * @param lfTag Configuration block for an LF-tag resource. Detailed below.
     * @param lfTagPolicy Configuration block for an LF-tag policy resource. Detailed below.
     * @param principal Principal to be granted the permissions on the resource. Supported principals are IAM users or IAM roles.
     * One of the following is required:
     * @param table Configuration block for a table resource. Detailed below.
     * @param tableWithColumns Configuration block for a table with columns resource. Detailed below.
     * The following arguments are optional:
     * @return A collection of values returned by getPermissions.
     */
    public suspend fun getPermissions(
        catalogId: String? = null,
        catalogResource: Boolean? = null,
        dataLocation: GetPermissionsDataLocation? = null,
        database: GetPermissionsDatabase? = null,
        lfTag: GetPermissionsLfTag? = null,
        lfTagPolicy: GetPermissionsLfTagPolicy? = null,
        principal: String,
        table: GetPermissionsTable? = null,
        tableWithColumns: GetPermissionsTableWithColumns? = null,
    ): GetPermissionsResult {
        val argument = GetPermissionsPlainArgs(
            catalogId = catalogId,
            catalogResource = catalogResource,
            dataLocation = dataLocation,
            database = database,
            lfTag = lfTag,
            lfTagPolicy = lfTagPolicy,
            principal = principal,
            table = table,
            tableWithColumns = tableWithColumns,
        )
        return getPermissionsResultToKotlin(getPermissionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPermissions].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lakeformation&#46;kotlin&#46;inputs&#46;GetPermissionsPlainArgs].
     * @return A collection of values returned by getPermissions.
     */
    public suspend fun getPermissions(argument: suspend GetPermissionsPlainArgsBuilder.() -> Unit):
        GetPermissionsResult {
        val builder = GetPermissionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPermissionsResultToKotlin(getPermissionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a Lake Formation resource.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.lakeformation.LakeformationFunctions;
     * import com.pulumi.aws.lakeformation.inputs.GetResourceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = LakeformationFunctions.getResource(GetResourceArgs.builder()
     *             .arn("arn:aws:s3:::tf-acc-test-9151654063908211878")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResource.
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(argument: GetResourcePlainArgs): GetResourceResult =
        getResourceResultToKotlin(getResourcePlain(argument.toJava()).await())

    /**
     * @see [getResource].
     * @param arn ARN of the resource, an S3 path.
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(arn: String): GetResourceResult {
        val argument = GetResourcePlainArgs(
            arn = arn,
        )
        return getResourceResultToKotlin(getResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getResource].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;lakeformation&#46;kotlin&#46;inputs&#46;GetResourcePlainArgs].
     * @return A collection of values returned by getResource.
     */
    public suspend fun getResource(argument: suspend GetResourcePlainArgsBuilder.() -> Unit):
        GetResourceResult {
        val builder = GetResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceResultToKotlin(getResourcePlain(builtArgument.toJava()).await())
    }
}
