@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [LfTag].
 */
@PulumiTagMarker
public class LfTagResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LfTagArgs = LfTagArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LfTagArgsBuilder.() -> Unit) {
        val builder = LfTagArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LfTag {
        val builtJavaResource = com.pulumi.aws.lakeformation.LfTag(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LfTag(builtJavaResource)
    }
}

/**
 * Creates an LF-Tag with the specified name and values. Each key must have at least one value. The maximum number of values permitted is 15.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.LfTag;
 * import com.pulumi.aws.lakeformation.LfTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LfTag("example", LfTagArgs.builder()
 *             .key("module")
 *             .values(
 *                 "Orders",
 *                 "Sales",
 *                 "Customers")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lake Formation LF-Tags using the `catalog_id:key`. If you have not set a Catalog ID specify the AWS Account ID that the database is in. For example:
 * ```sh
 *  $ pulumi import aws:lakeformation/lfTag:LfTag example 123456789012:some_key
 * ```
 *
 */
public class LfTag internal constructor(
    override val javaResource: com.pulumi.aws.lakeformation.LfTag,
) : KotlinCustomResource(javaResource, LfTagMapper) {
    /**
     * ID of the Data Catalog to create the tag in. If omitted, this defaults to the AWS Account ID.
     */
    public val catalogId: Output<String>
        get() = javaResource.catalogId().applyValue({ args0 -> args0 })

    /**
     * Key-name for the tag.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * List of possible values an attribute can take.
     */
    public val values: Output<List<String>>
        get() = javaResource.values().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object LfTagMapper : ResourceMapper<LfTag> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lakeformation.LfTag::class == javaResource::class

    override fun map(javaResource: Resource): LfTag = LfTag(
        javaResource as
            com.pulumi.aws.lakeformation.LfTag,
    )
}

/**
 * @see [LfTag].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LfTag].
 */
public suspend fun lfTag(name: String, block: suspend LfTagResourceBuilder.() -> Unit): LfTag {
    val builder = LfTagResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LfTag].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lfTag(name: String): LfTag {
    val builder = LfTagResourceBuilder()
    builder.name(name)
    return builder.build()
}
