@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.ResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Registers a Lake Formation resource (e.g., S3 bucket) as managed by the Data Catalog. In other words, the S3 path is added to the data lake.
 * Choose a role that has read/write access to the chosen Amazon S3 path or use the service-linked role. When you register the S3 path, the service-linked role and a new inline policy are created on your behalf. Lake Formation adds the first path to the inline policy and attaches it to the service-linked role. When you register subsequent paths, Lake Formation adds the path to the existing policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.S3Functions;
 * import com.pulumi.aws.s3.inputs.GetBucketArgs;
 * import com.pulumi.aws.lakeformation.Resource;
 * import com.pulumi.aws.lakeformation.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var exampleBucket = S3Functions.getBucket(GetBucketArgs.builder()
 *             .bucket("an-example-bucket")
 *             .build());
 *         var exampleResource = new Resource("exampleResource", ResourceArgs.builder()
 *             .arn(exampleBucket.applyValue(getBucketResult -> getBucketResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 * @property arn Amazon Resource Name (ARN) of the resource, an S3 path.
 * @property roleArn Role that has read/write access to the resource. If not provided, the Lake Formation service-linked role must exist and is used.
 * > **NOTE:** AWS does not support registering an S3 location with an IAM role and subsequently updating the S3 location registration to a service-linked role.
 */
public data class ResourceArgs(
    public val arn: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.ResourceArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.ResourceArgs =
        com.pulumi.aws.lakeformation.ResourceArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceArgs].
 */
@PulumiTagMarker
public class ResourceArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the resource, an S3 path.
     */
    @JvmName("vkcjgwbgysyxwwtg")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Role that has read/write access to the resource. If not provided, the Lake Formation service-linked role must exist and is used.
     * > **NOTE:** AWS does not support registering an S3 location with an IAM role and subsequently updating the S3 location registration to a service-linked role.
     */
    @JvmName("tiprfurpfjeqtfah")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the resource, an S3 path.
     */
    @JvmName("euyvsmmwqmfbhrfi")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Role that has read/write access to the resource. If not provided, the Lake Formation service-linked role must exist and is used.
     * > **NOTE:** AWS does not support registering an S3 location with an IAM role and subsequently updating the S3 location registration to a service-linked role.
     */
    @JvmName("hqcguspgupreonug")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): ResourceArgs = ResourceArgs(
        arn = arn,
        roleArn = roleArn,
    )
}
