@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin

import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagsDatabase
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagsLfTag
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagsTable
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagsTableWithColumns
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagsDatabase.Companion.toKotlin as resourceLfTagsDatabaseToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagsLfTag.Companion.toKotlin as resourceLfTagsLfTagToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagsTable.Companion.toKotlin as resourceLfTagsTableToKotlin
import com.pulumi.aws.lakeformation.kotlin.outputs.ResourceLfTagsTableWithColumns.Companion.toKotlin as resourceLfTagsTableWithColumnsToKotlin

/**
 * Builder for [ResourceLfTags].
 */
@PulumiTagMarker
public class ResourceLfTagsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceLfTagsArgs = ResourceLfTagsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceLfTagsArgsBuilder.() -> Unit) {
        val builder = ResourceLfTagsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResourceLfTags {
        val builtJavaResource = com.pulumi.aws.lakeformation.ResourceLfTags(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceLfTags(builtJavaResource)
    }
}

/**
 * Manages an attachment between one or more existing LF-tags and an existing Lake Formation resource.
 * ## Example Usage
 * ### Database Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.LfTag;
 * import com.pulumi.aws.lakeformation.LfTagArgs;
 * import com.pulumi.aws.lakeformation.ResourceLfTags;
 * import com.pulumi.aws.lakeformation.ResourceLfTagsArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagsDatabaseArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagsLfTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLfTag = new LfTag("exampleLfTag", LfTagArgs.builder()
 *             .key("right")
 *             .values(
 *                 "abbey",
 *                 "village",
 *                 "luffield",
 *                 "woodcote",
 *                 "copse",
 *                 "chapel",
 *                 "stowe",
 *                 "club")
 *             .build());
 *         var exampleResourceLfTags = new ResourceLfTags("exampleResourceLfTags", ResourceLfTagsArgs.builder()
 *             .database(ResourceLfTagsDatabaseArgs.builder()
 *                 .name(aws_glue_catalog_database.example().name())
 *                 .build())
 *             .lfTags(ResourceLfTagsLfTagArgs.builder()
 *                 .key(exampleLfTag.key())
 *                 .value("stowe")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple Tags Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lakeformation.LfTag;
 * import com.pulumi.aws.lakeformation.LfTagArgs;
 * import com.pulumi.aws.lakeformation.ResourceLfTags;
 * import com.pulumi.aws.lakeformation.ResourceLfTagsArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagsDatabaseArgs;
 * import com.pulumi.aws.lakeformation.inputs.ResourceLfTagsLfTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLfTag = new LfTag("exampleLfTag", LfTagArgs.builder()
 *             .key("right")
 *             .values(
 *                 "abbey",
 *                 "village",
 *                 "luffield",
 *                 "woodcote",
 *                 "copse",
 *                 "chapel",
 *                 "stowe",
 *                 "club")
 *             .build());
 *         var example2 = new LfTag("example2", LfTagArgs.builder()
 *             .key("left")
 *             .values(
 *                 "farm",
 *                 "theloop",
 *                 "aintree",
 *                 "brooklands",
 *                 "maggotts",
 *                 "becketts",
 *                 "vale")
 *             .build());
 *         var exampleResourceLfTags = new ResourceLfTags("exampleResourceLfTags", ResourceLfTagsArgs.builder()
 *             .database(ResourceLfTagsDatabaseArgs.builder()
 *                 .name(aws_glue_catalog_database.example().name())
 *                 .build())
 *             .lfTags(
 *                 ResourceLfTagsLfTagArgs.builder()
 *                     .key("right")
 *                     .value("luffield")
 *                     .build(),
 *                 ResourceLfTagsLfTagArgs.builder()
 *                     .key("left")
 *                     .value("aintree")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 */
public class ResourceLfTags internal constructor(
    override val javaResource: com.pulumi.aws.lakeformation.ResourceLfTags,
) : KotlinCustomResource(javaResource, ResourceLfTagsMapper) {
    /**
     * Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
     */
    public val catalogId: Output<String>
        get() = javaResource.catalogId().applyValue({ args0 -> args0 })

    /**
     * Configuration block for a database resource. See below.
     */
    public val database: Output<ResourceLfTagsDatabase>
        get() = javaResource.database().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceLfTagsDatabaseToKotlin(args0)
            })
        })

    /**
     * Set of LF-tags to attach to the resource. See below.
     * Exactly one of the following is required:
     */
    public val lfTags: Output<List<ResourceLfTagsLfTag>>
        get() = javaResource.lfTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceLfTagsLfTagToKotlin(args0)
                })
            })
        })

    /**
     * Configuration block for a table resource. See below.
     */
    public val table: Output<ResourceLfTagsTable>
        get() = javaResource.table().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceLfTagsTableToKotlin(args0)
            })
        })

    /**
     * Configuration block for a table with columns resource. See below.
     * The following arguments are optional:
     */
    public val tableWithColumns: Output<ResourceLfTagsTableWithColumns>
        get() = javaResource.tableWithColumns().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceLfTagsTableWithColumnsToKotlin(args0)
            })
        })
}

public object ResourceLfTagsMapper : ResourceMapper<ResourceLfTags> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lakeformation.ResourceLfTags::class == javaResource::class

    override fun map(javaResource: Resource): ResourceLfTags = ResourceLfTags(
        javaResource as
            com.pulumi.aws.lakeformation.ResourceLfTags,
    )
}

/**
 * @see [ResourceLfTags].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceLfTags].
 */
public suspend fun resourceLfTags(
    name: String,
    block: suspend ResourceLfTagsResourceBuilder.() -> Unit,
): ResourceLfTags {
    val builder = ResourceLfTagsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceLfTags].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceLfTags(name: String): ResourceLfTags {
    val builder = ResourceLfTagsResourceBuilder()
    builder.name(name)
    return builder.build()
}
