@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.GetPermissionsDataLocation.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn ARN that uniquely identifies the data location resource.
 * The following argument is optional:
 * @property catalogId Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
 */
public data class GetPermissionsDataLocation(
    public val arn: String,
    public val catalogId: String,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.GetPermissionsDataLocation> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.GetPermissionsDataLocation =
        com.pulumi.aws.lakeformation.inputs.GetPermissionsDataLocation.builder()
            .arn(arn.let({ args0 -> args0 }))
            .catalogId(catalogId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPermissionsDataLocation].
 */
@PulumiTagMarker
public class GetPermissionsDataLocationBuilder internal constructor() {
    private var arn: String? = null

    private var catalogId: String? = null

    /**
     * @param value ARN that uniquely identifies the data location resource.
     * The following argument is optional:
     */
    @JvmName("iyprmgerjpotxcvp")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
     */
    @JvmName("dteudcmhytvmobrh")
    public suspend fun catalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogId = mapped
    }

    internal fun build(): GetPermissionsDataLocation = GetPermissionsDataLocation(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        catalogId = catalogId ?: throw PulumiNullFieldException("catalogId"),
    )
}
