@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.GetPermissionsDatabase.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property name Name of the database resource. Unique to the Data Catalog.
 * The following argument is optional:
 */
public data class GetPermissionsDatabase(
    public val catalogId: String,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.GetPermissionsDatabase> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.GetPermissionsDatabase =
        com.pulumi.aws.lakeformation.inputs.GetPermissionsDatabase.builder()
            .catalogId(catalogId.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPermissionsDatabase].
 */
@PulumiTagMarker
public class GetPermissionsDatabaseBuilder internal constructor() {
    private var catalogId: String? = null

    private var name: String? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("mgjqyveibjljknni")
    public suspend fun catalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the database resource. Unique to the Data Catalog.
     * The following argument is optional:
     */
    @JvmName("wqrlenvfdxniqtkp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetPermissionsDatabase = GetPermissionsDatabase(
        catalogId = catalogId ?: throw PulumiNullFieldException("catalogId"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
