@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTagPolicyExpression.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key Key-name of an LF-Tag.
 * @property values List of possible values of an LF-Tag.
 */
public data class GetPermissionsLfTagPolicyExpression(
    public val key: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTagPolicyExpression> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTagPolicyExpression =
        com.pulumi.aws.lakeformation.inputs.GetPermissionsLfTagPolicyExpression.builder()
            .key(key.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetPermissionsLfTagPolicyExpression].
 */
@PulumiTagMarker
public class GetPermissionsLfTagPolicyExpressionBuilder internal constructor() {
    private var key: String? = null

    private var values: List<String>? = null

    /**
     * @param value Key-name of an LF-Tag.
     */
    @JvmName("quaniqofxumrohsq")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value List of possible values of an LF-Tag.
     */
    @JvmName("ksenyqkdkkbggcsu")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values List of possible values of an LF-Tag.
     */
    @JvmName("ixeavdynybfwlfko")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetPermissionsLfTagPolicyExpression = GetPermissionsLfTagPolicyExpression(
        key = key ?: throw PulumiNullFieldException("key"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
