@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.GetPermissionsTable.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property databaseName Name of the database for the table. Unique to a Data Catalog.
 * The following arguments are optional:
 * @property name Name of the table. At least one of `name` or `wildcard` is required.
 * @property wildcard Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
 */
public data class GetPermissionsTable(
    public val catalogId: String,
    public val databaseName: String,
    public val name: String,
    public val wildcard: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.GetPermissionsTable> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.GetPermissionsTable =
        com.pulumi.aws.lakeformation.inputs.GetPermissionsTable.builder()
            .catalogId(catalogId.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .wildcard(wildcard?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPermissionsTable].
 */
@PulumiTagMarker
public class GetPermissionsTableBuilder internal constructor() {
    private var catalogId: String? = null

    private var databaseName: String? = null

    private var name: String? = null

    private var wildcard: Boolean? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("lbenervbibacwnpa")
    public suspend fun catalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogId = mapped
    }

    /**
     * @param value Name of the database for the table. Unique to a Data Catalog.
     * The following arguments are optional:
     */
    @JvmName("iwuabuimuguognki")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value Name of the table. At least one of `name` or `wildcard` is required.
     */
    @JvmName("oswvtopunpbwfsbp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
     */
    @JvmName("fhywnbmftensjock")
    public suspend fun wildcard(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.wildcard = mapped
    }

    internal fun build(): GetPermissionsTable = GetPermissionsTable(
        catalogId = catalogId ?: throw PulumiNullFieldException("catalogId"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        name = name ?: throw PulumiNullFieldException("name"),
        wildcard = wildcard,
    )
}
