@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.GetPermissionsTableWithColumns.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property columnNames Set of column names for the table. At least one of `column_names` or `excluded_column_names` is required.
 * @property databaseName Name of the database for the table with columns resource. Unique to the Data Catalog.
 * @property excludedColumnNames Set of column names for the table to exclude. At least one of `column_names` or `excluded_column_names` is required.
 * @property name Name of the table resource.
 * The following arguments are optional:
 * @property wildcard Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
 */
public data class GetPermissionsTableWithColumns(
    public val catalogId: String,
    public val columnNames: List<String>? = null,
    public val databaseName: String,
    public val excludedColumnNames: List<String>? = null,
    public val name: String,
    public val wildcard: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.GetPermissionsTableWithColumns> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.GetPermissionsTableWithColumns =
        com.pulumi.aws.lakeformation.inputs.GetPermissionsTableWithColumns.builder()
            .catalogId(catalogId.let({ args0 -> args0 }))
            .columnNames(columnNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .excludedColumnNames(excludedColumnNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.let({ args0 -> args0 }))
            .wildcard(wildcard?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPermissionsTableWithColumns].
 */
@PulumiTagMarker
public class GetPermissionsTableWithColumnsBuilder internal constructor() {
    private var catalogId: String? = null

    private var columnNames: List<String>? = null

    private var databaseName: String? = null

    private var excludedColumnNames: List<String>? = null

    private var name: String? = null

    private var wildcard: Boolean? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("rbhnvtukhqfnjgvg")
    public suspend fun catalogId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogId = mapped
    }

    /**
     * @param value Set of column names for the table. At least one of `column_names` or `excluded_column_names` is required.
     */
    @JvmName("mvrvufaagoqetkex")
    public suspend fun columnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.columnNames = mapped
    }

    /**
     * @param values Set of column names for the table. At least one of `column_names` or `excluded_column_names` is required.
     */
    @JvmName("uqjgtvohsgpvoess")
    public suspend fun columnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.columnNames = mapped
    }

    /**
     * @param value Name of the database for the table with columns resource. Unique to the Data Catalog.
     */
    @JvmName("fjcoiqsnsxyawsyh")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value Set of column names for the table to exclude. At least one of `column_names` or `excluded_column_names` is required.
     */
    @JvmName("eutypixxllpmmwau")
    public suspend fun excludedColumnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.excludedColumnNames = mapped
    }

    /**
     * @param values Set of column names for the table to exclude. At least one of `column_names` or `excluded_column_names` is required.
     */
    @JvmName("bxiqaufdqpdigqua")
    public suspend fun excludedColumnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.excludedColumnNames = mapped
    }

    /**
     * @param value Name of the table resource.
     * The following arguments are optional:
     */
    @JvmName("itqbglwnmresscog")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
     */
    @JvmName("bxwxkxtgrwateqfl")
    public suspend fun wildcard(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.wildcard = mapped
    }

    internal fun build(): GetPermissionsTableWithColumns = GetPermissionsTableWithColumns(
        catalogId = catalogId ?: throw PulumiNullFieldException("catalogId"),
        columnNames = columnNames,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        excludedColumnNames = excludedColumnNames,
        name = name ?: throw PulumiNullFieldException("name"),
        wildcard = wildcard,
    )
}
