@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.GetResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResource.
 * @property arn ARN of the resource, an S3 path.
 */
public data class GetResourcePlainArgs(
    public val arn: String,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.GetResourcePlainArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.GetResourcePlainArgs =
        com.pulumi.aws.lakeformation.inputs.GetResourcePlainArgs.builder()
            .arn(arn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourcePlainArgs].
 */
@PulumiTagMarker
public class GetResourcePlainArgsBuilder internal constructor() {
    private var arn: String? = null

    /**
     * @param value ARN of the resource, an S3 path.
     */
    @JvmName("vnhqrfjrrpehygty")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    internal fun build(): GetResourcePlainArgs = GetResourcePlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
    )
}
