@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.PermissionsLfTagPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property expressions A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
 * The following argument is optional:
 * @property resourceType The resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
 */
public data class PermissionsLfTagPolicyArgs(
    public val catalogId: Output<String>? = null,
    public val expressions: Output<List<PermissionsLfTagPolicyExpressionArgs>>,
    public val resourceType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.PermissionsLfTagPolicyArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.PermissionsLfTagPolicyArgs =
        com.pulumi.aws.lakeformation.inputs.PermissionsLfTagPolicyArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .expressions(
                expressions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceType(resourceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionsLfTagPolicyArgs].
 */
@PulumiTagMarker
public class PermissionsLfTagPolicyArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var expressions: Output<List<PermissionsLfTagPolicyExpressionArgs>>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("jhxqvhxdnfjhaujv")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("wcbchmymocdjhmbl")
    public suspend fun expressions(`value`: Output<List<PermissionsLfTagPolicyExpressionArgs>>) {
        this.expressions = value
    }

    @JvmName("ynbgkkusaehurhul")
    public suspend fun expressions(vararg values: Output<PermissionsLfTagPolicyExpressionArgs>) {
        this.expressions = Output.all(values.asList())
    }

    /**
     * @param values A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("xyqlkvhbqmnfgyio")
    public suspend fun expressions(values: List<Output<PermissionsLfTagPolicyExpressionArgs>>) {
        this.expressions = Output.all(values)
    }

    /**
     * @param value The resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
     */
    @JvmName("drxadnqgqineetdb")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("smkirhdgayacqpqx")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("sxhjqqdhmbnuxgkl")
    public suspend fun expressions(`value`: List<PermissionsLfTagPolicyExpressionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expressions = mapped
    }

    /**
     * @param argument A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("wkilrfwyxojmgqob")
    public suspend
    fun expressions(argument: List<suspend PermissionsLfTagPolicyExpressionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PermissionsLfTagPolicyExpressionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expressions = mapped
    }

    /**
     * @param argument A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("stvgxrhsbekcgwhm")
    public suspend fun expressions(
        vararg
        argument: suspend PermissionsLfTagPolicyExpressionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PermissionsLfTagPolicyExpressionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expressions = mapped
    }

    /**
     * @param argument A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("wyvtbpqedtlohsep")
    public suspend
    fun expressions(argument: suspend PermissionsLfTagPolicyExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PermissionsLfTagPolicyExpressionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.expressions = mapped
    }

    /**
     * @param values A list of tag conditions that apply to the resource's tag policy. Configuration block for tag conditions that apply to the policy. See `expression` below.
     * The following argument is optional:
     */
    @JvmName("kphhfmlgqdjxvlon")
    public suspend fun expressions(vararg values: PermissionsLfTagPolicyExpressionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expressions = mapped
    }

    /**
     * @param value The resource type for which the tag policy applies. Valid values are `DATABASE` and `TABLE`.
     */
    @JvmName("fgmnbnscrxghhulv")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): PermissionsLfTagPolicyArgs = PermissionsLfTagPolicyArgs(
        catalogId = catalogId,
        expressions = expressions ?: throw PulumiNullFieldException("expressions"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
    )
}
