@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.inputs

import com.pulumi.aws.lakeformation.inputs.ResourceLfTagsTableWithColumnsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property columnNames Set of column names for the table.
 * @property databaseName Name of the database for the table with columns resource. Unique to the Data Catalog.
 * @property excludedColumnNames Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
 * @property name Name of the table resource.
 * @property wildcard Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
 * The following arguments are optional:
 */
public data class ResourceLfTagsTableWithColumnsArgs(
    public val catalogId: Output<String>? = null,
    public val columnNames: Output<List<String>>? = null,
    public val databaseName: Output<String>,
    public val excludedColumnNames: Output<List<String>>? = null,
    public val name: Output<String>,
    public val wildcard: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.lakeformation.inputs.ResourceLfTagsTableWithColumnsArgs> {
    override fun toJava(): com.pulumi.aws.lakeformation.inputs.ResourceLfTagsTableWithColumnsArgs =
        com.pulumi.aws.lakeformation.inputs.ResourceLfTagsTableWithColumnsArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .columnNames(columnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .excludedColumnNames(excludedColumnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .wildcard(wildcard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceLfTagsTableWithColumnsArgs].
 */
@PulumiTagMarker
public class ResourceLfTagsTableWithColumnsArgsBuilder internal constructor() {
    private var catalogId: Output<String>? = null

    private var columnNames: Output<List<String>>? = null

    private var databaseName: Output<String>? = null

    private var excludedColumnNames: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var wildcard: Output<Boolean>? = null

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("kiuejjiqqkuqsicf")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Set of column names for the table.
     */
    @JvmName("jcdqjpmehfoeogvx")
    public suspend fun columnNames(`value`: Output<List<String>>) {
        this.columnNames = value
    }

    @JvmName("vitbaqwleyooflcn")
    public suspend fun columnNames(vararg values: Output<String>) {
        this.columnNames = Output.all(values.asList())
    }

    /**
     * @param values Set of column names for the table.
     */
    @JvmName("rghyccwmhvlelljj")
    public suspend fun columnNames(values: List<Output<String>>) {
        this.columnNames = Output.all(values)
    }

    /**
     * @param value Name of the database for the table with columns resource. Unique to the Data Catalog.
     */
    @JvmName("dpgbkjijsjemkhua")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
     */
    @JvmName("ectnajkaohvhtgob")
    public suspend fun excludedColumnNames(`value`: Output<List<String>>) {
        this.excludedColumnNames = value
    }

    @JvmName("ifpaiqvnytflyydi")
    public suspend fun excludedColumnNames(vararg values: Output<String>) {
        this.excludedColumnNames = Output.all(values.asList())
    }

    /**
     * @param values Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
     */
    @JvmName("eylwyljmlwerxarv")
    public suspend fun excludedColumnNames(values: List<Output<String>>) {
        this.excludedColumnNames = Output.all(values)
    }

    /**
     * @param value Name of the table resource.
     */
    @JvmName("yghbpdmrxsxhkuvs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
     * The following arguments are optional:
     */
    @JvmName("wdrnxmviglmxwxln")
    public suspend fun wildcard(`value`: Output<Boolean>) {
        this.wildcard = value
    }

    /**
     * @param value Identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    @JvmName("ygrkpqwjwmiayupq")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Set of column names for the table.
     */
    @JvmName("agespjfsbigmcsys")
    public suspend fun columnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnNames = mapped
    }

    /**
     * @param values Set of column names for the table.
     */
    @JvmName("vsikvpddehsyednj")
    public suspend fun columnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnNames = mapped
    }

    /**
     * @param value Name of the database for the table with columns resource. Unique to the Data Catalog.
     */
    @JvmName("puymvqaokwurxbhh")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
     */
    @JvmName("qtploqiedhfnqkfn")
    public suspend fun excludedColumnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedColumnNames = mapped
    }

    /**
     * @param values Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
     */
    @JvmName("ehjnslwavcerheld")
    public suspend fun excludedColumnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedColumnNames = mapped
    }

    /**
     * @param value Name of the table resource.
     */
    @JvmName("xjvkxgarmwkwkjgj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
     * The following arguments are optional:
     */
    @JvmName("toqbtkaksdfbooxb")
    public suspend fun wildcard(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcard = mapped
    }

    internal fun build(): ResourceLfTagsTableWithColumnsArgs = ResourceLfTagsTableWithColumnsArgs(
        catalogId = catalogId,
        columnNames = columnNames,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        excludedColumnNames = excludedColumnNames,
        name = name ?: throw PulumiNullFieldException("name"),
        wildcard = wildcard,
    )
}
