@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property databaseName Name of the database for the table. Unique to a Data Catalog.
 * The following arguments are optional:
 * @property name Name of the table. At least one of `name` or `wildcard` is required.
 * @property wildcard Whether to use a wildcard representing every table under a database. At least one of `name` or `wildcard` is required. Defaults to `false`.
 */
public data class GetPermissionsTable(
    public val catalogId: String,
    public val databaseName: String,
    public val name: String,
    public val wildcard: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.GetPermissionsTable):
            GetPermissionsTable = GetPermissionsTable(
            catalogId = javaType.catalogId(),
            databaseName = javaType.databaseName(),
            name = javaType.name(),
            wildcard = javaType.wildcard().map({ args0 -> args0 }).orElse(null),
        )
    }
}
