@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getResource.
 * @property arn
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastModified Date and time the resource was last modified in [RFC 3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 * @property roleArn Role that the resource was registered with.
 */
public data class GetResourceResult(
    public val arn: String,
    public val id: String,
    public val lastModified: String,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.GetResourceResult):
            GetResourceResult = GetResourceResult(
            arn = javaType.arn(),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            roleArn = javaType.roleArn(),
        )
    }
}
