@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn Amazon Resource Name (ARN) that uniquely identifies the data location resource.
 * The following argument is optional:
 * @property catalogId Identifier for the Data Catalog where the location is registered with Lake Formation. By default, it is the account ID of the caller.
 */
public data class PermissionsDataLocation(
    public val arn: String,
    public val catalogId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.PermissionsDataLocation):
            PermissionsDataLocation = PermissionsDataLocation(
            arn = javaType.arn(),
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
