@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lakeformation.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property catalogId Identifier for the Data Catalog. By default, it is the account ID of the caller.
 * @property columnNames Set of column names for the table.
 * @property databaseName Name of the database for the table with columns resource. Unique to the Data Catalog.
 * @property excludedColumnNames Set of column names for the table to exclude. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
 * @property name Name of the table resource.
 * @property wildcard Whether to use a column wildcard. If `excluded_column_names` is included, `wildcard` must be set to `true` to avoid the provider reporting a difference.
 * The following arguments are optional:
 */
public data class ResourceLfTagsTableWithColumns(
    public val catalogId: String? = null,
    public val columnNames: List<String>? = null,
    public val databaseName: String,
    public val excludedColumnNames: List<String>? = null,
    public val name: String,
    public val wildcard: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.lakeformation.outputs.ResourceLfTagsTableWithColumns):
            ResourceLfTagsTableWithColumns = ResourceLfTagsTableWithColumns(
            catalogId = javaType.catalogId().map({ args0 -> args0 }).orElse(null),
            columnNames = javaType.columnNames().map({ args0 -> args0 }),
            databaseName = javaType.databaseName(),
            excludedColumnNames = javaType.excludedColumnNames().map({ args0 -> args0 }),
            name = javaType.name(),
            wildcard = javaType.wildcard().map({ args0 -> args0 }).orElse(null),
        )
    }
}
