@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.CodeSigningConfigArgs.builder
import com.pulumi.aws.lambda.kotlin.inputs.CodeSigningConfigAllowedPublishersArgs
import com.pulumi.aws.lambda.kotlin.inputs.CodeSigningConfigAllowedPublishersArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.CodeSigningConfigPoliciesArgs
import com.pulumi.aws.lambda.kotlin.inputs.CodeSigningConfigPoliciesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Lambda Code Signing Config resource. A code signing configuration defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment validation checks fail).
 * For information about Lambda code signing configurations and how to use them, see [configuring code signing for Lambda functions](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.CodeSigningConfig;
 * import com.pulumi.aws.lambda.CodeSigningConfigArgs;
 * import com.pulumi.aws.lambda.inputs.CodeSigningConfigAllowedPublishersArgs;
 * import com.pulumi.aws.lambda.inputs.CodeSigningConfigPoliciesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var newCsc = new CodeSigningConfig("newCsc", CodeSigningConfigArgs.builder()
 *             .allowedPublishers(CodeSigningConfigAllowedPublishersArgs.builder()
 *                 .signingProfileVersionArns(
 *                     aws_signer_signing_profile.example1().arn(),
 *                     aws_signer_signing_profile.example2().arn())
 *                 .build())
 *             .policies(CodeSigningConfigPoliciesArgs.builder()
 *                 .untrustedArtifactOnDeployment("Warn")
 *                 .build())
 *             .description("My awesome code signing config.")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Code Signing Configs using their ARN. For example:
 * ```sh
 *  $ pulumi import aws:lambda/codeSigningConfig:CodeSigningConfig imported_csc arn:aws:lambda:us-west-2:123456789012:code-signing-config:csc-0f6c334abcdea4d8b
 * ```
 * @property allowedPublishers A configuration block of allowed publishers as signing profiles for this code signing configuration. Detailed below.
 * @property description Descriptive name for this code signing configuration.
 * @property policies A configuration block of code signing policies that define the actions to take if the validation checks fail. Detailed below.
 */
public data class CodeSigningConfigArgs(
    public val allowedPublishers: Output<CodeSigningConfigAllowedPublishersArgs>? = null,
    public val description: Output<String>? = null,
    public val policies: Output<CodeSigningConfigPoliciesArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.CodeSigningConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.CodeSigningConfigArgs =
        com.pulumi.aws.lambda.CodeSigningConfigArgs.builder()
            .allowedPublishers(allowedPublishers?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .policies(policies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CodeSigningConfigArgs].
 */
@PulumiTagMarker
public class CodeSigningConfigArgsBuilder internal constructor() {
    private var allowedPublishers: Output<CodeSigningConfigAllowedPublishersArgs>? = null

    private var description: Output<String>? = null

    private var policies: Output<CodeSigningConfigPoliciesArgs>? = null

    /**
     * @param value A configuration block of allowed publishers as signing profiles for this code signing configuration. Detailed below.
     */
    @JvmName("qvmeibttbypsyqhs")
    public suspend fun allowedPublishers(`value`: Output<CodeSigningConfigAllowedPublishersArgs>) {
        this.allowedPublishers = value
    }

    /**
     * @param value Descriptive name for this code signing configuration.
     */
    @JvmName("cbmpckiecqcmfcvb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A configuration block of code signing policies that define the actions to take if the validation checks fail. Detailed below.
     */
    @JvmName("heegvlggfymbhmkc")
    public suspend fun policies(`value`: Output<CodeSigningConfigPoliciesArgs>) {
        this.policies = value
    }

    /**
     * @param value A configuration block of allowed publishers as signing profiles for this code signing configuration. Detailed below.
     */
    @JvmName("ehsfbfnbysobvinb")
    public suspend fun allowedPublishers(`value`: CodeSigningConfigAllowedPublishersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedPublishers = mapped
    }

    /**
     * @param argument A configuration block of allowed publishers as signing profiles for this code signing configuration. Detailed below.
     */
    @JvmName("rcgpghhbikrgpndm")
    public suspend
    fun allowedPublishers(argument: suspend CodeSigningConfigAllowedPublishersArgsBuilder.() -> Unit) {
        val toBeMapped = CodeSigningConfigAllowedPublishersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.allowedPublishers = mapped
    }

    /**
     * @param value Descriptive name for this code signing configuration.
     */
    @JvmName("nnsakvkqwmsaroen")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A configuration block of code signing policies that define the actions to take if the validation checks fail. Detailed below.
     */
    @JvmName("bmsimtmbcwvqmijm")
    public suspend fun policies(`value`: CodeSigningConfigPoliciesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param argument A configuration block of code signing policies that define the actions to take if the validation checks fail. Detailed below.
     */
    @JvmName("mtlxoqvyirupkmey")
    public suspend fun policies(argument: suspend CodeSigningConfigPoliciesArgsBuilder.() -> Unit) {
        val toBeMapped = CodeSigningConfigPoliciesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policies = mapped
    }

    internal fun build(): CodeSigningConfigArgs = CodeSigningConfigArgs(
        allowedPublishers = allowedPublishers,
        description = description,
        policies = policies,
    )
}
