@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingAmazonManagedKafkaEventSourceConfig
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingDestinationConfig
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingDocumentDbEventSourceConfig
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingFilterCriteria
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingScalingConfig
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSelfManagedEventSource
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSelfManagedKafkaEventSourceConfig
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSourceAccessConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingAmazonManagedKafkaEventSourceConfig.Companion.toKotlin as eventSourceMappingAmazonManagedKafkaEventSourceConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingDestinationConfig.Companion.toKotlin as eventSourceMappingDestinationConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingDocumentDbEventSourceConfig.Companion.toKotlin as eventSourceMappingDocumentDbEventSourceConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingFilterCriteria.Companion.toKotlin as eventSourceMappingFilterCriteriaToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingScalingConfig.Companion.toKotlin as eventSourceMappingScalingConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSelfManagedEventSource.Companion.toKotlin as eventSourceMappingSelfManagedEventSourceToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSelfManagedKafkaEventSourceConfig.Companion.toKotlin as eventSourceMappingSelfManagedKafkaEventSourceConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.EventSourceMappingSourceAccessConfiguration.Companion.toKotlin as eventSourceMappingSourceAccessConfigurationToKotlin

/**
 * Builder for [EventSourceMapping].
 */
@PulumiTagMarker
public class EventSourceMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventSourceMappingArgs = EventSourceMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventSourceMappingArgsBuilder.() -> Unit) {
        val builder = EventSourceMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventSourceMapping {
        val builtJavaResource = com.pulumi.aws.lambda.EventSourceMapping(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventSourceMapping(builtJavaResource)
    }
}

/**
 * Provides a Lambda event source mapping. This allows Lambda functions to get events from Kinesis, DynamoDB, SQS, Amazon MQ and Managed Streaming for Apache Kafka (MSK).
 * For information about Lambda and how to use it, see [What is AWS Lambda?](http://docs.aws.amazon.com/lambda/latest/dg/welcome.html).
 * For information about event source mappings, see [CreateEventSourceMapping](http://docs.aws.amazon.com/lambda/latest/dg/API_CreateEventSourceMapping.html) in the API docs.
 * ## Example Usage
 * ### DynamoDB
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(aws_dynamodb_table.example().stream_arn())
 *             .functionName(aws_lambda_function.example().arn())
 *             .startingPosition("LATEST")
 *             .build());
 *     }
 * }
 * ```
 * ### Kinesis
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(aws_kinesis_stream.example().arn())
 *             .functionName(aws_lambda_function.example().arn())
 *             .startingPosition("LATEST")
 *             .build());
 *     }
 * }
 * ```
 * ### Managed Streaming for Apache Kafka (MSK)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(aws_msk_cluster.example().arn())
 *             .functionName(aws_lambda_function.example().arn())
 *             .topics("Example")
 *             .startingPosition("TRIM_HORIZON")
 *             .build());
 *     }
 * }
 * ```
 * ### Self Managed Apache Kafka
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedEventSourceArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .functionName(aws_lambda_function.example().arn())
 *             .topics("Example")
 *             .startingPosition("TRIM_HORIZON")
 *             .selfManagedEventSource(EventSourceMappingSelfManagedEventSourceArgs.builder()
 *                 .endpoints(Map.of("KAFKA_BOOTSTRAP_SERVERS", "kafka1.example.com:9092,kafka2.example.com:9092"))
 *                 .build())
 *             .sourceAccessConfigurations(
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VPC_SUBNET")
 *                     .uri("subnet:subnet-example1")
 *                     .build(),
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VPC_SUBNET")
 *                     .uri("subnet:subnet-example2")
 *                     .build(),
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VPC_SECURITY_GROUP")
 *                     .uri("security_group:sg-example")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SQS
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(aws_sqs_queue.sqs_queue_test().arn())
 *             .functionName(aws_lambda_function.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### SQS with event filter
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .eventSourceArn(aws_sqs_queue.sqs_queue_test().arn())
 *             .functionName(aws_lambda_function.example().arn())
 *             .filterCriteria(EventSourceMappingFilterCriteriaArgs.builder()
 *                 .filters(EventSourceMappingFilterCriteriaFilterArgs.builder()
 *                     .pattern(serializeJson(
 *                         jsonObject(
 *                             jsonProperty("body", jsonObject(
 *                                 jsonProperty("Temperature", jsonArray(jsonObject(
 *                                     jsonProperty("numeric", jsonArray(
 *                                         ">",
 *                                         0,
 *                                         "<=",
 *                                         100
 *                                     ))
 *                                 ))),
 *                                 jsonProperty("Location", jsonArray("New York"))
 *                             ))
 *                         )))
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Amazon MQ (ActiveMQ)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .batchSize(10)
 *             .eventSourceArn(aws_mq_broker.example().arn())
 *             .enabled(true)
 *             .functionName(aws_lambda_function.example().arn())
 *             .queues("example")
 *             .sourceAccessConfigurations(EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                 .type("BASIC_AUTH")
 *                 .uri(aws_secretsmanager_secret_version.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Amazon MQ (RabbitMQ)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.EventSourceMapping;
 * import com.pulumi.aws.lambda.EventSourceMappingArgs;
 * import com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourceMapping("example", EventSourceMappingArgs.builder()
 *             .batchSize(1)
 *             .eventSourceArn(aws_mq_broker.example().arn())
 *             .enabled(true)
 *             .functionName(aws_lambda_function.example().arn())
 *             .queues("example")
 *             .sourceAccessConfigurations(
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("VIRTUAL_HOST")
 *                     .uri("/example")
 *                     .build(),
 *                 EventSourceMappingSourceAccessConfigurationArgs.builder()
 *                     .type("BASIC_AUTH")
 *                     .uri(aws_secretsmanager_secret_version.example().arn())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lambda event source mappings using the `UUID` (event source mapping identifier). For example:
 * ```sh
 *  $ pulumi import aws:lambda/eventSourceMapping:EventSourceMapping event_source_mapping 12345kxodurf3443
 * ```
 *
 */
public class EventSourceMapping internal constructor(
    override val javaResource: com.pulumi.aws.lambda.EventSourceMapping,
) : KotlinCustomResource(javaResource, EventSourceMappingMapper) {
    /**
     * Additional configuration block for Amazon Managed Kafka sources. Incompatible with "self_managed_event_source" and "self_managed_kafka_event_source_config". Detailed below.
     */
    public val amazonManagedKafkaEventSourceConfig:
        Output<EventSourceMappingAmazonManagedKafkaEventSourceConfig>
        get() = javaResource.amazonManagedKafkaEventSourceConfig().applyValue({ args0 ->
            args0.let({ args0 -> eventSourceMappingAmazonManagedKafkaEventSourceConfigToKotlin(args0) })
        })

    /**
     * The largest number of records that Lambda will retrieve from your event source at the time of invocation. Defaults to `100` for DynamoDB, Kinesis, MQ and MSK, `10` for SQS.
     */
    public val batchSize: Output<Int>?
        get() = javaResource.batchSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * - (Optional) If the function returns an error, split the batch in two and retry. Only available for stream sources (DynamoDB and Kinesis). Defaults to `false`.
     */
    public val bisectBatchOnFunctionError: Output<Boolean>?
        get() = javaResource.bisectBatchOnFunctionError().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * - (Optional) An Amazon SQS queue or Amazon SNS topic destination for failed records. Only available for stream sources (DynamoDB and Kinesis). Detailed below.
     */
    public val destinationConfig: Output<EventSourceMappingDestinationConfig>?
        get() = javaResource.destinationConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventSourceMappingDestinationConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * - (Optional) Configuration settings for a DocumentDB event source. Detailed below.
     */
    public val documentDbEventSourceConfig: Output<EventSourceMappingDocumentDbEventSourceConfig>?
        get() = javaResource.documentDbEventSourceConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventSourceMappingDocumentDbEventSourceConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Determines if the mapping will be enabled on creation. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The event source ARN - this is required for Kinesis stream, DynamoDB stream, SQS queue, MQ broker, MSK cluster or DocumentDB change stream.  It is incompatible with a Self Managed Kafka source.
     */
    public val eventSourceArn: Output<String>?
        get() = javaResource.eventSourceArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The criteria to use for [event filtering](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html) Kinesis stream, DynamoDB stream, SQS queue event sources. Detailed below.
     */
    public val filterCriteria: Output<EventSourceMappingFilterCriteria>?
        get() = javaResource.filterCriteria().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventSourceMappingFilterCriteriaToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The the ARN of the Lambda function the event source mapping is sending events to. (Note: this is a computed value that differs from `function_name` above.)
     */
    public val functionArn: Output<String>
        get() = javaResource.functionArn().applyValue({ args0 -> args0 })

    /**
     * The name or the ARN of the Lambda function that will be subscribing to events.
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * A list of current response type enums applied to the event source mapping for [AWS Lambda checkpointing](https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting). Only available for SQS and stream sources (DynamoDB and Kinesis). Valid values: `ReportBatchItemFailures`.
     */
    public val functionResponseTypes: Output<List<String>>?
        get() = javaResource.functionResponseTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The date this resource was last modified.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The result of the last AWS Lambda invocation of your Lambda function.
     */
    public val lastProcessingResult: Output<String>
        get() = javaResource.lastProcessingResult().applyValue({ args0 -> args0 })

    /**
     * The maximum amount of time to gather records before invoking the function, in seconds (between 0 and 300). Records will continue to buffer (or accumulate in the case of an SQS queue event source) until either `maximum_batching_window_in_seconds` expires or `batch_size` has been met. For streaming event sources, defaults to as soon as records are available in the stream. If the batch it reads from the stream/queue only has one record in it, Lambda only sends one record to the function. Only available for stream sources (DynamoDB and Kinesis) and SQS standard queues.
     */
    public val maximumBatchingWindowInSeconds: Output<Int>?
        get() = javaResource.maximumBatchingWindowInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * - (Optional) The maximum age of a record that Lambda sends to a function for processing. Only available for stream sources (DynamoDB and Kinesis). Must be either -1 (forever, and the default value) or between 60 and 604800 (inclusive).
     */
    public val maximumRecordAgeInSeconds: Output<Int>
        get() = javaResource.maximumRecordAgeInSeconds().applyValue({ args0 -> args0 })

    /**
     * - (Optional) The maximum number of times to retry when the function returns an error. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of -1 (forever), maximum of 10000.
     */
    public val maximumRetryAttempts: Output<Int>
        get() = javaResource.maximumRetryAttempts().applyValue({ args0 -> args0 })

    /**
     * - (Optional) The number of batches to process from each shard concurrently. Only available for stream sources (DynamoDB and Kinesis). Minimum and default of 1, maximum of 10.
     */
    public val parallelizationFactor: Output<Int>
        get() = javaResource.parallelizationFactor().applyValue({ args0 -> args0 })

    /**
     * The name of the Amazon MQ broker destination queue to consume. Only available for MQ sources. The list must contain exactly one queue name.
     */
    public val queues: Output<String>?
        get() = javaResource.queues().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Scaling configuration of the event source. Only available for SQS queues. Detailed below.
     */
    public val scalingConfig: Output<EventSourceMappingScalingConfig>?
        get() = javaResource.scalingConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventSourceMappingScalingConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * - (Optional) For Self Managed Kafka sources, the location of the self managed cluster. If set, configuration must also include `source_access_configuration`. Detailed below.
     */
    public val selfManagedEventSource: Output<EventSourceMappingSelfManagedEventSource>?
        get() = javaResource.selfManagedEventSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventSourceMappingSelfManagedEventSourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Additional configuration block for Self Managed Kafka sources. Incompatible with "event_source_arn" and "amazon_managed_kafka_event_source_config". Detailed below.
     */
    public val selfManagedKafkaEventSourceConfig:
        Output<EventSourceMappingSelfManagedKafkaEventSourceConfig>
        get() = javaResource.selfManagedKafkaEventSourceConfig().applyValue({ args0 ->
            args0.let({ args0 -> eventSourceMappingSelfManagedKafkaEventSourceConfigToKotlin(args0) })
        })

    /**
     * For Self Managed Kafka sources, the access configuration for the source. If set, configuration must also include `self_managed_event_source`. Detailed below.
     */
    public val sourceAccessConfigurations: Output<List<EventSourceMappingSourceAccessConfiguration>>?
        get() = javaResource.sourceAccessConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eventSourceMappingSourceAccessConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The position in the stream where AWS Lambda should start reading. Must be one of `AT_TIMESTAMP` (Kinesis only), `LATEST` or `TRIM_HORIZON` if getting events from Kinesis, DynamoDB, MSK or Self Managed Apache Kafka. Must not be provided if getting events from SQS. More information about these positions can be found in the [AWS DynamoDB Streams API Reference](https://docs&#46;aws&#46;amazon&#46;com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator&#46;html) and [AWS Kinesis API Reference](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType).
     */
    public val startingPosition: Output<String>?
        get() = javaResource.startingPosition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of the data record which to start reading when using `starting_position` set to `AT_TIMESTAMP`. If a record with this exact timestamp does not exist, the next later record is chosen. If the timestamp is older than the current trim horizon, the oldest available record is chosen.
     */
    public val startingPositionTimestamp: Output<String>?
        get() = javaResource.startingPositionTimestamp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the event source mapping.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The reason the event source mapping is in its current state.
     */
    public val stateTransitionReason: Output<String>
        get() = javaResource.stateTransitionReason().applyValue({ args0 -> args0 })

    /**
     * The name of the Kafka topics. Only available for MSK sources. A single topic name must be specified.
     */
    public val topics: Output<List<String>>?
        get() = javaResource.topics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The duration in seconds of a processing window for [AWS Lambda streaming analytics](https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-windows). The range is between 1 second up to 900 seconds. Only available for stream sources (DynamoDB and Kinesis).
     */
    public val tumblingWindowInSeconds: Output<Int>?
        get() = javaResource.tumblingWindowInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The UUID of the created event source mapping.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })
}

public object EventSourceMappingMapper : ResourceMapper<EventSourceMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.EventSourceMapping::class == javaResource::class

    override fun map(javaResource: Resource): EventSourceMapping = EventSourceMapping(
        javaResource as
            com.pulumi.aws.lambda.EventSourceMapping,
    )
}

/**
 * @see [EventSourceMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventSourceMapping].
 */
public suspend fun eventSourceMapping(
    name: String,
    block: suspend EventSourceMappingResourceBuilder.() -> Unit,
): EventSourceMapping {
    val builder = EventSourceMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventSourceMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventSourceMapping(name: String): EventSourceMapping {
    val builder = EventSourceMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
