@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.asset.Archive
import com.pulumi.aws.lambda.kotlin.outputs.FunctionDeadLetterConfig
import com.pulumi.aws.lambda.kotlin.outputs.FunctionEnvironment
import com.pulumi.aws.lambda.kotlin.outputs.FunctionEphemeralStorage
import com.pulumi.aws.lambda.kotlin.outputs.FunctionFileSystemConfig
import com.pulumi.aws.lambda.kotlin.outputs.FunctionImageConfig
import com.pulumi.aws.lambda.kotlin.outputs.FunctionSnapStart
import com.pulumi.aws.lambda.kotlin.outputs.FunctionTracingConfig
import com.pulumi.aws.lambda.kotlin.outputs.FunctionVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.lambda.kotlin.outputs.FunctionDeadLetterConfig.Companion.toKotlin as functionDeadLetterConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.FunctionEnvironment.Companion.toKotlin as functionEnvironmentToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.FunctionEphemeralStorage.Companion.toKotlin as functionEphemeralStorageToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.FunctionFileSystemConfig.Companion.toKotlin as functionFileSystemConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.FunctionImageConfig.Companion.toKotlin as functionImageConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.FunctionSnapStart.Companion.toKotlin as functionSnapStartToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.FunctionTracingConfig.Companion.toKotlin as functionTracingConfigToKotlin
import com.pulumi.aws.lambda.kotlin.outputs.FunctionVpcConfig.Companion.toKotlin as functionVpcConfigToKotlin

/**
 * Builder for [Function].
 */
@PulumiTagMarker
public class FunctionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FunctionArgs = FunctionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FunctionArgsBuilder.() -> Unit) {
        val builder = FunctionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Function {
        val builtJavaResource = com.pulumi.aws.lambda.Function(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Function(builtJavaResource)
    }
}

/**
 * Provides a Lambda Function resource. Lambda allows you to trigger execution of code in response to events in AWS, enabling serverless backend solutions. The Lambda Function itself includes source code and runtime configuration.
 * For information about Lambda and how to use it, see [What is AWS Lambda?](https://docs.aws.amazon.com/lambda/latest/dg/welcome.html)
 * > **NOTE:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), EC2 subnets and security groups associated with Lambda Functions can take up to 45 minutes to successfully delete.
 * > **NOTE:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking an `aws.lambda.Function` with environment variables, the IAM role associated with the function may have been deleted and recreated _after_ the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role, or 2) by using Pulumi to `taint` the function and `apply` your configuration again to recreate the function. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)
 * > To give an external source (like an EventBridge Rule, SNS, or S3) permission to access the Lambda function, use the `aws.lambda.Permission` resource. See [Lambda Permission Model](https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html) for more details. On the other hand, the `role` argument of this resource is the function's execution role for identity and access to AWS services and resources.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.archive.ArchiveFunctions;
 * import com.pulumi.archive.inputs.GetFileArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionEnvironmentArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var iamForLambda = new Role("iamForLambda", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var lambda = ArchiveFunctions.getFile(GetFileArgs.builder()
 *             .type("zip")
 *             .sourceFile("lambda.js")
 *             .outputPath("lambda_function_payload.zip")
 *             .build());
 *         var testLambda = new Function("testLambda", FunctionArgs.builder()
 *             .code(new FileArchive("lambda_function_payload.zip"))
 *             .role(iamForLambda.arn())
 *             .handler("index.test")
 *             .runtime("nodejs18.x")
 *             .environment(FunctionEnvironmentArgs.builder()
 *                 .variables(Map.of("foo", "bar"))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Layers
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.LayerVersion;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLayerVersion = new LayerVersion("exampleLayerVersion");
 *         var exampleFunction = new Function("exampleFunction", FunctionArgs.builder()
 *             .layers(exampleLayerVersion.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Ephemeral Storage
 * Lambda Function Ephemeral Storage(`/tmp`) allows you to configure the storage upto `10` GB. The default value set to `512` MB.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionEphemeralStorageArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var iamForLambda = new Role("iamForLambda", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testLambda = new Function("testLambda", FunctionArgs.builder()
 *             .code(new FileArchive("lambda_function_payload.zip"))
 *             .role(iamForLambda.arn())
 *             .handler("index.test")
 *             .runtime("nodejs18.x")
 *             .ephemeralStorage(FunctionEphemeralStorageArgs.builder()
 *                 .size(10240)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda File Systems
 * Lambda File Systems allow you to connect an Amazon Elastic File System (EFS) file system to a Lambda function to share data across function invocations, access existing data including large files, and save function state.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.FileSystemArgs;
 * import com.pulumi.aws.efs.MountTarget;
 * import com.pulumi.aws.efs.MountTargetArgs;
 * import com.pulumi.aws.efs.AccessPoint;
 * import com.pulumi.aws.efs.AccessPointArgs;
 * import com.pulumi.aws.efs.inputs.AccessPointRootDirectoryArgs;
 * import com.pulumi.aws.efs.inputs.AccessPointRootDirectoryCreationInfoArgs;
 * import com.pulumi.aws.efs.inputs.AccessPointPosixUserArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionFileSystemConfigArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionVpcConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var efsForLambda = new FileSystem("efsForLambda", FileSystemArgs.builder()
 *             .tags(Map.of("Name", "efs_for_lambda"))
 *             .build());
 *         var alpha = new MountTarget("alpha", MountTargetArgs.builder()
 *             .fileSystemId(efsForLambda.id())
 *             .subnetId(aws_subnet.subnet_for_lambda().id())
 *             .securityGroups(aws_security_group.sg_for_lambda().id())
 *             .build());
 *         var accessPointForLambda = new AccessPoint("accessPointForLambda", AccessPointArgs.builder()
 *             .fileSystemId(efsForLambda.id())
 *             .rootDirectory(AccessPointRootDirectoryArgs.builder()
 *                 .path("/lambda")
 *                 .creationInfo(AccessPointRootDirectoryCreationInfoArgs.builder()
 *                     .ownerGid(1000)
 *                     .ownerUid(1000)
 *                     .permissions("777")
 *                     .build())
 *                 .build())
 *             .posixUser(AccessPointPosixUserArgs.builder()
 *                 .gid(1000)
 *                 .uid(1000)
 *                 .build())
 *             .build());
 *         var example = new Function("example", FunctionArgs.builder()
 *             .fileSystemConfig(FunctionFileSystemConfigArgs.builder()
 *                 .arn(accessPointForLambda.arn())
 *                 .localMountPath("/mnt/efs")
 *                 .build())
 *             .vpcConfig(FunctionVpcConfigArgs.builder()
 *                 .subnetIds(aws_subnet.subnet_for_lambda().id())
 *                 .securityGroupIds(aws_security_group.sg_for_lambda().id())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(alpha)
 *                 .build());
 *     }
 * }
 * ```
 * ## CloudWatch Logging and Permissions
 * For more information about CloudWatch Logs for Lambda, see the [Lambda User Guide](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions-logs.html).
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const config = new pulumi.Config();
 * const lambdaFunctionName = config.get("lambdaFunctionName") || "lambda_function_name";
 * // This is to optionally manage the CloudWatch Log Group for the Lambda Function.
 * // If skipping this resource configuration, also add "logs:CreateLogGroup" to the IAM policy below.
 * const example = new aws.cloudwatch.LogGroup("example", {retentionInDays: 14});
 * const lambdaLoggingPolicyDocument = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: [
 *             "logs:CreateLogGroup",
 *             "logs:CreateLogStream",
 *             "logs:PutLogEvents",
 *         ],
 *         resources: ["arn:aws:logs:*:*:*"],
 *     }],
 * });
 * const lambdaLoggingPolicy = new aws.iam.Policy("lambdaLoggingPolicy", {
 *     path: "/",
 *     description: "IAM policy for logging from a lambda",
 *     policy: lambdaLoggingPolicyDocument.then(lambdaLoggingPolicyDocument => lambdaLoggingPolicyDocument.json),
 * });
 * const lambdaLogs = new aws.iam.RolePolicyAttachment("lambdaLogs", {
 *     role: aws_iam_role.iam_for_lambda.name,
 *     policyArn: lambdaLoggingPolicy.arn,
 * });
 * const testLambda = new aws.lambda.Function("testLambda", {}, {
 *     dependsOn: [
 *         lambdaLogs,
 *         example,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * config = pulumi.Config()
 * lambda_function_name = config.get("lambdaFunctionName")
 * if lambda_function_name is None:
 *     lambda_function_name = "lambda_function_name"
 * # This is to optionally manage the CloudWatch Log Group for the Lambda Function.
 * # If skipping this resource configuration, also add "logs:CreateLogGroup" to the IAM policy below.
 * example = aws.cloudwatch.LogGroup("example", retention_in_days=14)
 * lambda_logging_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
 *     effect="Allow",
 *     actions=[
 *         "logs:CreateLogGroup",
 *         "logs:CreateLogStream",
 *         "logs:PutLogEvents",
 *     ],
 *     resources=["arn:aws:logs:*:*:*"],
 * )])
 * lambda_logging_policy = aws.iam.Policy("lambdaLoggingPolicy",
 *     path="/",
 *     description="IAM policy for logging from a lambda",
 *     policy=lambda_logging_policy_document.json)
 * lambda_logs = aws.iam.RolePolicyAttachment("lambdaLogs",
 *     role=aws_iam_role["iam_for_lambda"]["name"],
 *     policy_arn=lambda_logging_policy.arn)
 * test_lambda = aws.lambda_.Function("testLambda", opts=pulumi.ResourceOptions(depends_on=[
 *         lambda_logs,
 *         example,
 *     ]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var lambdaFunctionName = config.Get("lambdaFunctionName") ?? "lambda_function_name";
 *     // This is to optionally manage the CloudWatch Log Group for the Lambda Function.
 *     // If skipping this resource configuration, also add "logs:CreateLogGroup" to the IAM policy below.
 *     var example = new Aws.CloudWatch.LogGroup("example", new()
 *     {
 *         RetentionInDays = 14,
 *     });
 *     var lambdaLoggingPolicyDocument = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "logs:CreateLogGroup",
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:logs:*:*:*",
 *                 },
 *             },
 *         },
 *     });
 *     var lambdaLoggingPolicy = new Aws.Iam.Policy("lambdaLoggingPolicy", new()
 *     {
 *         Path = "/",
 *         Description = "IAM policy for logging from a lambda",
 *         PolicyDocument = lambdaLoggingPolicyDocument.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var lambdaLogs = new Aws.Iam.RolePolicyAttachment("lambdaLogs", new()
 *     {
 *         Role = aws_iam_role.Iam_for_lambda.Name,
 *         PolicyArn = lambdaLoggingPolicy.Arn,
 *     });
 *     var testLambda = new Aws.Lambda.Function("testLambda", new()
 *     {
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn = new[]
 *         {
 *             lambdaLogs,
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		lambdaFunctionName := "lambda_function_name"
 * 		if param := cfg.Get("lambdaFunctionName"); param != "" {
 * 			lambdaFunctionName = param
 * 		}
 * 		example, err := cloudwatch.NewLogGroup(ctx, "example", &cloudwatch.LogGroupArgs{
 * 			RetentionInDays: pulumi.Int(14),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambdaLoggingPolicyDocument, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"logs:CreateLogGroup",
 * 						"logs:CreateLogStream",
 * 						"logs:PutLogEvents",
 * 					},
 * 					Resources: []string{
 * 						"arn:aws:logs:*:*:*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambdaLoggingPolicy, err := iam.NewPolicy(ctx, "lambdaLoggingPolicy", &iam.PolicyArgs{
 * 			Path:        pulumi.String("/"),
 * 			Description: pulumi.String("IAM policy for logging from a lambda"),
 * 			Policy:      *pulumi.String(lambdaLoggingPolicyDocument.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambdaLogs, err := iam.NewRolePolicyAttachment(ctx, "lambdaLogs", &iam.RolePolicyAttachmentArgs{
 * 			Role:      pulumi.Any(aws_iam_role.Iam_for_lambda.Name),
 * 			PolicyArn: lambdaLoggingPolicy.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lambda.NewFunction(ctx, "testLambda", nil, pulumi.DependsOn([]pulumi.Resource{
 * 			lambdaLogs,
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var lambdaFunctionName = config.get("lambdaFunctionName").orElse("lambda_function_name");
 *         var example = new LogGroup("example", LogGroupArgs.builder()
 *             .retentionInDays(14)
 *             .build());
 *         final var lambdaLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "logs:CreateLogGroup",
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents")
 *                 .resources("arn:aws:logs:*:*:*")
 *                 .build())
 *             .build());
 *         var lambdaLoggingPolicy = new Policy("lambdaLoggingPolicy", PolicyArgs.builder()
 *             .path("/")
 *             .description("IAM policy for logging from a lambda")
 *             .policy(lambdaLoggingPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var lambdaLogs = new RolePolicyAttachment("lambdaLogs", RolePolicyAttachmentArgs.builder()
 *             .role(aws_iam_role.iam_for_lambda().name())
 *             .policyArn(lambdaLoggingPolicy.arn())
 *             .build());
 *         var testLambda = new Function("testLambda", FunctionArgs.Empty, CustomResourceOptions.builder()
 *             .dependsOn(
 *                 lambdaLogs,
 *                 example)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   lambdaFunctionName:
 *     type: string
 *     default: lambda_function_name
 * resources:
 *   testLambda:
 *     type: aws:lambda:Function
 *     options:
 *       dependson:
 *         - ${lambdaLogs}
 *         - ${example}
 *   # This is to optionally manage the CloudWatch Log Group for the Lambda Function.
 *   # If skipping this resource configuration, also add "logs:CreateLogGroup" to the IAM policy below.
 *   example:
 *     type: aws:cloudwatch:LogGroup
 *     properties:
 *       retentionInDays: 14
 *   lambdaLoggingPolicy:
 *     type: aws:iam:Policy
 *     properties:
 *       path: /
 *       description: IAM policy for logging from a lambda
 *       policy: ${lambdaLoggingPolicyDocument.json}
 *   lambdaLogs:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       role: ${aws_iam_role.iam_for_lambda.name}
 *       policyArn: ${lambdaLoggingPolicy.arn}
 * variables:
 *   lambdaLoggingPolicyDocument:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - logs:CreateLogGroup
 *               - logs:CreateLogStream
 *               - logs:PutLogEvents
 *             resources:
 *               - arn:aws:logs:*:*:*
 * ```
 * ## Specifying the Deployment Package
 * AWS Lambda expects source code to be provided as a deployment package whose structure varies depending on which `runtime` is in use. See [Runtimes](https://docs&#46;aws&#46;amazon&#46;com/lambda/latest/dg/API_CreateFunction&#46;html#SSS-CreateFunction-request-Runtime) for the valid values of `runtime`&#46; The expected structure of the deployment package can be found in [the AWS Lambda documentation for each runtime](https://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html).
 * Once you have created your deployment package you can specify it either directly as a local file (using the `filename` argument) or indirectly via Amazon S3 (using the `s3_bucket`, `s3_key` and `s3_object_version` arguments). When providing the deployment package via S3 it may be useful to use the `aws.s3.BucketObjectv2` resource to upload it.
 * For larger deployment packages it is recommended by Amazon to upload via S3, since the S3 API has better support for uploading large files efficiently.
 * ## Import
 * Using `pulumi import`, import Lambda Functions using the `function_name`. For example:
 * ```sh
 *  $ pulumi import aws:lambda/function:Function test_lambda my_test_lambda_function
 * ```
 *
 */
public class Function internal constructor(
    override val javaResource: com.pulumi.aws.lambda.Function,
) : KotlinCustomResource(javaResource, FunctionMapper) {
    /**
     * Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`&#46; Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
     */
    public val architectures: Output<List<String>>
        get() = javaResource.architectures().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
     */
    public val code: Output<Archive>?
        get() = javaResource.code().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
     */
    public val codeSigningConfigArn: Output<String>?
        get() = javaResource.codeSigningConfigArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val deadLetterConfig: Output<FunctionDeadLetterConfig>?
        get() = javaResource.deadLetterConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> functionDeadLetterConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Description of what your Lambda Function does.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val environment: Output<FunctionEnvironment>?
        get() = javaResource.environment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    functionEnvironmentToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
     */
    public val ephemeralStorage: Output<FunctionEphemeralStorage>
        get() = javaResource.ephemeralStorage().applyValue({ args0 ->
            args0.let({ args0 ->
                functionEphemeralStorageToKotlin(args0)
            })
        })

    /**
     * Configuration block. Detailed below.
     */
    public val fileSystemConfig: Output<FunctionFileSystemConfig>?
        get() = javaResource.fileSystemConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> functionFileSystemConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
     */
    public val handler: Output<String>?
        get() = javaResource.handler().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block. Detailed below.
     */
    public val imageConfig: Output<FunctionImageConfig>?
        get() = javaResource.imageConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    functionImageConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
     */
    public val imageUri: Output<String>?
        get() = javaResource.imageUri().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARN to be used for invoking Lambda Function from API Gateway - to be used in `aws.apigateway.Integration`'s `uri`.
     */
    public val invokeArn: Output<String>
        get() = javaResource.invokeArn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
     */
    public val kmsKeyArn: Output<String>?
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Date this resource was last modified.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
     */
    public val layers: Output<List<String>>?
        get() = javaResource.layers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
     */
    public val memorySize: Output<Int>?
        get() = javaResource.memorySize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique name for your Lambda Function.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
     */
    public val packageType: Output<String>?
        get() = javaResource.packageType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
     */
    public val publish: Output<Boolean>?
        get() = javaResource.publish().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARN identifying your Lambda Function Version (if versioning is enabled via `publish = true`).
     */
    public val qualifiedArn: Output<String>
        get() = javaResource.qualifiedArn().applyValue({ args0 -> args0 })

    /**
     * Qualified ARN (ARN with lambda version number) to be used for invoking Lambda Function from API Gateway - to be used in `aws.apigateway.Integration`'s `uri`.
     */
    public val qualifiedInvokeArn: Output<String>
        get() = javaResource.qualifiedInvokeArn().applyValue({ args0 -> args0 })

    /**
     * **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
     */
    @Deprecated(
        message = """
  AWS no longer supports this operation. This attribute now has no effect and will be removed in a
      future major version.
  """,
    )
    public val replaceSecurityGroupsOnDestroy: Output<Boolean>?
        get() = javaResource.replaceSecurityGroupsOnDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
     */
    @Deprecated(
        message = """
  AWS no longer supports this operation. This attribute now has no effect and will be removed in a
      future major version.
  """,
    )
    public val replacementSecurityGroupIds: Output<List<String>>?
        get() = javaResource.replacementSecurityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
     */
    public val reservedConcurrentExecutions: Output<Int>?
        get() = javaResource.reservedConcurrentExecutions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.
     * The following arguments are optional:
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
     */
    public val runtime: Output<String>?
        get() = javaResource.runtime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
     */
    public val s3Bucket: Output<String>?
        get() = javaResource.s3Bucket().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
     */
    public val s3Key: Output<String>?
        get() = javaResource.s3Key().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
     */
    public val s3ObjectVersion: Output<String>?
        get() = javaResource.s3ObjectVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the signing job.
     */
    public val signingJobArn: Output<String>
        get() = javaResource.signingJobArn().applyValue({ args0 -> args0 })

    /**
     * ARN of the signing profile version.
     * * `snap_start.optimization_status` - Optimization status of the snap start configuration. Valid values are `On` and `Off`.
     */
    public val signingProfileVersionArn: Output<String>
        get() = javaResource.signingProfileVersionArn().applyValue({ args0 -> args0 })

    /**
     * Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
     */
    public val skipDestroy: Output<Boolean>?
        get() = javaResource.skipDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Snap start settings block. Detailed below.
     */
    public val snapStart: Output<FunctionSnapStart>?
        get() = javaResource.snapStart().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    functionSnapStartToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
     */
    public val sourceCodeHash: Output<String>
        get() = javaResource.sourceCodeHash().applyValue({ args0 -> args0 })

    /**
     * Size in bytes of the function .zip file.
     */
    public val sourceCodeSize: Output<Int>
        get() = javaResource.sourceCodeSize().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
     */
    public val timeout: Output<Int>?
        get() = javaResource.timeout().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block. Detailed below.
     */
    public val tracingConfig: Output<FunctionTracingConfig>
        get() = javaResource.tracingConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                functionTracingConfigToKotlin(args0)
            })
        })

    /**
     * Latest published version of your Lambda Function.
     * * `vpc_config.vpc_id` - ID of the VPC.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * Configuration block. Detailed below.
     */
    public val vpcConfig: Output<FunctionVpcConfig>?
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    functionVpcConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object FunctionMapper : ResourceMapper<Function> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.Function::class == javaResource::class

    override fun map(javaResource: Resource): Function = Function(
        javaResource as
            com.pulumi.aws.lambda.Function,
    )
}

/**
 * @see [Function].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Function].
 */
public suspend fun function(name: String, block: suspend FunctionResourceBuilder.() -> Unit):
    Function {
    val builder = FunctionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Function].
 * @param name The _unique_ name of the resulting resource.
 */
public fun function(name: String): Function {
    val builder = FunctionResourceBuilder()
    builder.name(name)
    return builder.build()
}
