@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.asset.Archive
import com.pulumi.aws.lambda.FunctionArgs.builder
import com.pulumi.aws.lambda.kotlin.enums.Runtime
import com.pulumi.aws.lambda.kotlin.inputs.FunctionDeadLetterConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.FunctionDeadLetterConfigArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.FunctionEnvironmentArgs
import com.pulumi.aws.lambda.kotlin.inputs.FunctionEnvironmentArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.FunctionEphemeralStorageArgs
import com.pulumi.aws.lambda.kotlin.inputs.FunctionEphemeralStorageArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.FunctionFileSystemConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.FunctionFileSystemConfigArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.FunctionImageConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.FunctionImageConfigArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.FunctionSnapStartArgs
import com.pulumi.aws.lambda.kotlin.inputs.FunctionSnapStartArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.FunctionTracingConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.FunctionTracingConfigArgsBuilder
import com.pulumi.aws.lambda.kotlin.inputs.FunctionVpcConfigArgs
import com.pulumi.aws.lambda.kotlin.inputs.FunctionVpcConfigArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Lambda Function resource. Lambda allows you to trigger execution of code in response to events in AWS, enabling serverless backend solutions. The Lambda Function itself includes source code and runtime configuration.
 * For information about Lambda and how to use it, see [What is AWS Lambda?](https://docs.aws.amazon.com/lambda/latest/dg/welcome.html)
 * > **NOTE:** Due to [AWS Lambda improved VPC networking changes that began deploying in September 2019](https://aws.amazon.com/blogs/compute/announcing-improved-vpc-networking-for-aws-lambda-functions/), EC2 subnets and security groups associated with Lambda Functions can take up to 45 minutes to successfully delete.
 * > **NOTE:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking an `aws.lambda.Function` with environment variables, the IAM role associated with the function may have been deleted and recreated _after_ the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role, or 2) by using Pulumi to `taint` the function and `apply` your configuration again to recreate the function. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)
 * > To give an external source (like an EventBridge Rule, SNS, or S3) permission to access the Lambda function, use the `aws.lambda.Permission` resource. See [Lambda Permission Model](https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html) for more details. On the other hand, the `role` argument of this resource is the function's execution role for identity and access to AWS services and resources.
 * ## Example Usage
 * ### Basic Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.archive.ArchiveFunctions;
 * import com.pulumi.archive.inputs.GetFileArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionEnvironmentArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var iamForLambda = new Role("iamForLambda", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var lambda = ArchiveFunctions.getFile(GetFileArgs.builder()
 *             .type("zip")
 *             .sourceFile("lambda.js")
 *             .outputPath("lambda_function_payload.zip")
 *             .build());
 *         var testLambda = new Function("testLambda", FunctionArgs.builder()
 *             .code(new FileArchive("lambda_function_payload.zip"))
 *             .role(iamForLambda.arn())
 *             .handler("index.test")
 *             .runtime("nodejs18.x")
 *             .environment(FunctionEnvironmentArgs.builder()
 *                 .variables(Map.of("foo", "bar"))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Layers
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.LayerVersion;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLayerVersion = new LayerVersion("exampleLayerVersion");
 *         var exampleFunction = new Function("exampleFunction", FunctionArgs.builder()
 *             .layers(exampleLayerVersion.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda Ephemeral Storage
 * Lambda Function Ephemeral Storage(`/tmp`) allows you to configure the storage upto `10` GB. The default value set to `512` MB.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionEphemeralStorageArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var iamForLambda = new Role("iamForLambda", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var testLambda = new Function("testLambda", FunctionArgs.builder()
 *             .code(new FileArchive("lambda_function_payload.zip"))
 *             .role(iamForLambda.arn())
 *             .handler("index.test")
 *             .runtime("nodejs18.x")
 *             .ephemeralStorage(FunctionEphemeralStorageArgs.builder()
 *                 .size(10240)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Lambda File Systems
 * Lambda File Systems allow you to connect an Amazon Elastic File System (EFS) file system to a Lambda function to share data across function invocations, access existing data including large files, and save function state.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.FileSystemArgs;
 * import com.pulumi.aws.efs.MountTarget;
 * import com.pulumi.aws.efs.MountTargetArgs;
 * import com.pulumi.aws.efs.AccessPoint;
 * import com.pulumi.aws.efs.AccessPointArgs;
 * import com.pulumi.aws.efs.inputs.AccessPointRootDirectoryArgs;
 * import com.pulumi.aws.efs.inputs.AccessPointRootDirectoryCreationInfoArgs;
 * import com.pulumi.aws.efs.inputs.AccessPointPosixUserArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionFileSystemConfigArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionVpcConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var efsForLambda = new FileSystem("efsForLambda", FileSystemArgs.builder()
 *             .tags(Map.of("Name", "efs_for_lambda"))
 *             .build());
 *         var alpha = new MountTarget("alpha", MountTargetArgs.builder()
 *             .fileSystemId(efsForLambda.id())
 *             .subnetId(aws_subnet.subnet_for_lambda().id())
 *             .securityGroups(aws_security_group.sg_for_lambda().id())
 *             .build());
 *         var accessPointForLambda = new AccessPoint("accessPointForLambda", AccessPointArgs.builder()
 *             .fileSystemId(efsForLambda.id())
 *             .rootDirectory(AccessPointRootDirectoryArgs.builder()
 *                 .path("/lambda")
 *                 .creationInfo(AccessPointRootDirectoryCreationInfoArgs.builder()
 *                     .ownerGid(1000)
 *                     .ownerUid(1000)
 *                     .permissions("777")
 *                     .build())
 *                 .build())
 *             .posixUser(AccessPointPosixUserArgs.builder()
 *                 .gid(1000)
 *                 .uid(1000)
 *                 .build())
 *             .build());
 *         var example = new Function("example", FunctionArgs.builder()
 *             .fileSystemConfig(FunctionFileSystemConfigArgs.builder()
 *                 .arn(accessPointForLambda.arn())
 *                 .localMountPath("/mnt/efs")
 *                 .build())
 *             .vpcConfig(FunctionVpcConfigArgs.builder()
 *                 .subnetIds(aws_subnet.subnet_for_lambda().id())
 *                 .securityGroupIds(aws_security_group.sg_for_lambda().id())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(alpha)
 *                 .build());
 *     }
 * }
 * ```
 * ## CloudWatch Logging and Permissions
 * For more information about CloudWatch Logs for Lambda, see the [Lambda User Guide](https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions-logs.html).
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const config = new pulumi.Config();
 * const lambdaFunctionName = config.get("lambdaFunctionName") || "lambda_function_name";
 * // This is to optionally manage the CloudWatch Log Group for the Lambda Function.
 * // If skipping this resource configuration, also add "logs:CreateLogGroup" to the IAM policy below.
 * const example = new aws.cloudwatch.LogGroup("example", {retentionInDays: 14});
 * const lambdaLoggingPolicyDocument = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         actions: [
 *             "logs:CreateLogGroup",
 *             "logs:CreateLogStream",
 *             "logs:PutLogEvents",
 *         ],
 *         resources: ["arn:aws:logs:*:*:*"],
 *     }],
 * });
 * const lambdaLoggingPolicy = new aws.iam.Policy("lambdaLoggingPolicy", {
 *     path: "/",
 *     description: "IAM policy for logging from a lambda",
 *     policy: lambdaLoggingPolicyDocument.then(lambdaLoggingPolicyDocument => lambdaLoggingPolicyDocument.json),
 * });
 * const lambdaLogs = new aws.iam.RolePolicyAttachment("lambdaLogs", {
 *     role: aws_iam_role.iam_for_lambda.name,
 *     policyArn: lambdaLoggingPolicy.arn,
 * });
 * const testLambda = new aws.lambda.Function("testLambda", {}, {
 *     dependsOn: [
 *         lambdaLogs,
 *         example,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * config = pulumi.Config()
 * lambda_function_name = config.get("lambdaFunctionName")
 * if lambda_function_name is None:
 *     lambda_function_name = "lambda_function_name"
 * # This is to optionally manage the CloudWatch Log Group for the Lambda Function.
 * # If skipping this resource configuration, also add "logs:CreateLogGroup" to the IAM policy below.
 * example = aws.cloudwatch.LogGroup("example", retention_in_days=14)
 * lambda_logging_policy_document = aws.iam.get_policy_document(statements=[aws.iam.GetPolicyDocumentStatementArgs(
 *     effect="Allow",
 *     actions=[
 *         "logs:CreateLogGroup",
 *         "logs:CreateLogStream",
 *         "logs:PutLogEvents",
 *     ],
 *     resources=["arn:aws:logs:*:*:*"],
 * )])
 * lambda_logging_policy = aws.iam.Policy("lambdaLoggingPolicy",
 *     path="/",
 *     description="IAM policy for logging from a lambda",
 *     policy=lambda_logging_policy_document.json)
 * lambda_logs = aws.iam.RolePolicyAttachment("lambdaLogs",
 *     role=aws_iam_role["iam_for_lambda"]["name"],
 *     policy_arn=lambda_logging_policy.arn)
 * test_lambda = aws.lambda_.Function("testLambda", opts=pulumi.ResourceOptions(depends_on=[
 *         lambda_logs,
 *         example,
 *     ]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var lambdaFunctionName = config.Get("lambdaFunctionName") ?? "lambda_function_name";
 *     // This is to optionally manage the CloudWatch Log Group for the Lambda Function.
 *     // If skipping this resource configuration, also add "logs:CreateLogGroup" to the IAM policy below.
 *     var example = new Aws.CloudWatch.LogGroup("example", new()
 *     {
 *         RetentionInDays = 14,
 *     });
 *     var lambdaLoggingPolicyDocument = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "logs:CreateLogGroup",
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:logs:*:*:*",
 *                 },
 *             },
 *         },
 *     });
 *     var lambdaLoggingPolicy = new Aws.Iam.Policy("lambdaLoggingPolicy", new()
 *     {
 *         Path = "/",
 *         Description = "IAM policy for logging from a lambda",
 *         PolicyDocument = lambdaLoggingPolicyDocument.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var lambdaLogs = new Aws.Iam.RolePolicyAttachment("lambdaLogs", new()
 *     {
 *         Role = aws_iam_role.Iam_for_lambda.Name,
 *         PolicyArn = lambdaLoggingPolicy.Arn,
 *     });
 *     var testLambda = new Aws.Lambda.Function("testLambda", new()
 *     {
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn = new[]
 *         {
 *             lambdaLogs,
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cloudwatch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lambda"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		lambdaFunctionName := "lambda_function_name"
 * 		if param := cfg.Get("lambdaFunctionName"); param != "" {
 * 			lambdaFunctionName = param
 * 		}
 * 		example, err := cloudwatch.NewLogGroup(ctx, "example", &cloudwatch.LogGroupArgs{
 * 			RetentionInDays: pulumi.Int(14),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambdaLoggingPolicyDocument, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Actions: []string{
 * 						"logs:CreateLogGroup",
 * 						"logs:CreateLogStream",
 * 						"logs:PutLogEvents",
 * 					},
 * 					Resources: []string{
 * 						"arn:aws:logs:*:*:*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambdaLoggingPolicy, err := iam.NewPolicy(ctx, "lambdaLoggingPolicy", &iam.PolicyArgs{
 * 			Path:        pulumi.String("/"),
 * 			Description: pulumi.String("IAM policy for logging from a lambda"),
 * 			Policy:      *pulumi.String(lambdaLoggingPolicyDocument.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		lambdaLogs, err := iam.NewRolePolicyAttachment(ctx, "lambdaLogs", &iam.RolePolicyAttachmentArgs{
 * 			Role:      pulumi.Any(aws_iam_role.Iam_for_lambda.Name),
 * 			PolicyArn: lambdaLoggingPolicy.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lambda.NewFunction(ctx, "testLambda", nil, pulumi.DependsOn([]pulumi.Resource{
 * 			lambdaLogs,
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var lambdaFunctionName = config.get("lambdaFunctionName").orElse("lambda_function_name");
 *         var example = new LogGroup("example", LogGroupArgs.builder()
 *             .retentionInDays(14)
 *             .build());
 *         final var lambdaLoggingPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "logs:CreateLogGroup",
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents")
 *                 .resources("arn:aws:logs:*:*:*")
 *                 .build())
 *             .build());
 *         var lambdaLoggingPolicy = new Policy("lambdaLoggingPolicy", PolicyArgs.builder()
 *             .path("/")
 *             .description("IAM policy for logging from a lambda")
 *             .policy(lambdaLoggingPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var lambdaLogs = new RolePolicyAttachment("lambdaLogs", RolePolicyAttachmentArgs.builder()
 *             .role(aws_iam_role.iam_for_lambda().name())
 *             .policyArn(lambdaLoggingPolicy.arn())
 *             .build());
 *         var testLambda = new Function("testLambda", FunctionArgs.Empty, CustomResourceOptions.builder()
 *             .dependsOn(
 *                 lambdaLogs,
 *                 example)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   lambdaFunctionName:
 *     type: string
 *     default: lambda_function_name
 * resources:
 *   testLambda:
 *     type: aws:lambda:Function
 *     options:
 *       dependson:
 *         - ${lambdaLogs}
 *         - ${example}
 *   # This is to optionally manage the CloudWatch Log Group for the Lambda Function.
 *   # If skipping this resource configuration, also add "logs:CreateLogGroup" to the IAM policy below.
 *   example:
 *     type: aws:cloudwatch:LogGroup
 *     properties:
 *       retentionInDays: 14
 *   lambdaLoggingPolicy:
 *     type: aws:iam:Policy
 *     properties:
 *       path: /
 *       description: IAM policy for logging from a lambda
 *       policy: ${lambdaLoggingPolicyDocument.json}
 *   lambdaLogs:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       role: ${aws_iam_role.iam_for_lambda.name}
 *       policyArn: ${lambdaLoggingPolicy.arn}
 * variables:
 *   lambdaLoggingPolicyDocument:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - logs:CreateLogGroup
 *               - logs:CreateLogStream
 *               - logs:PutLogEvents
 *             resources:
 *               - arn:aws:logs:*:*:*
 * ```
 * ## Specifying the Deployment Package
 * AWS Lambda expects source code to be provided as a deployment package whose structure varies depending on which `runtime` is in use. See [Runtimes](https://docs&#46;aws&#46;amazon&#46;com/lambda/latest/dg/API_CreateFunction&#46;html#SSS-CreateFunction-request-Runtime) for the valid values of `runtime`&#46; The expected structure of the deployment package can be found in [the AWS Lambda documentation for each runtime](https://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html).
 * Once you have created your deployment package you can specify it either directly as a local file (using the `filename` argument) or indirectly via Amazon S3 (using the `s3_bucket`, `s3_key` and `s3_object_version` arguments). When providing the deployment package via S3 it may be useful to use the `aws.s3.BucketObjectv2` resource to upload it.
 * For larger deployment packages it is recommended by Amazon to upload via S3, since the S3 API has better support for uploading large files efficiently.
 * ## Import
 * Using `pulumi import`, import Lambda Functions using the `function_name`. For example:
 * ```sh
 *  $ pulumi import aws:lambda/function:Function test_lambda my_test_lambda_function
 * ```
 * @property architectures Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`&#46; Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
 * @property code Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
 * @property codeSigningConfigArn To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
 * @property deadLetterConfig Configuration block. Detailed below.
 * @property description Description of what your Lambda Function does.
 * @property environment Configuration block. Detailed below.
 * @property ephemeralStorage The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
 * @property fileSystemConfig Configuration block. Detailed below.
 * @property handler Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
 * @property imageConfig Configuration block. Detailed below.
 * @property imageUri ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
 * @property kmsKeyArn Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
 * @property layers List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
 * @property memorySize Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
 * @property name Unique name for your Lambda Function.
 * @property packageType Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
 * @property publish Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
 * @property replaceSecurityGroupsOnDestroy **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
 * @property replacementSecurityGroupIds List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
 * @property reservedConcurrentExecutions Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
 * @property role Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.
 * The following arguments are optional:
 * @property runtime Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
 * @property s3Bucket S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
 * @property s3Key S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
 * @property s3ObjectVersion Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
 * @property skipDestroy Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
 * @property snapStart Snap start settings block. Detailed below.
 * @property sourceCodeHash Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
 * @property tags Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeout Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
 * @property tracingConfig Configuration block. Detailed below.
 * @property vpcConfig Configuration block. Detailed below.
 */
public data class FunctionArgs(
    public val architectures: Output<List<String>>? = null,
    public val code: Output<Archive>? = null,
    public val codeSigningConfigArn: Output<String>? = null,
    public val deadLetterConfig: Output<FunctionDeadLetterConfigArgs>? = null,
    public val description: Output<String>? = null,
    public val environment: Output<FunctionEnvironmentArgs>? = null,
    public val ephemeralStorage: Output<FunctionEphemeralStorageArgs>? = null,
    public val fileSystemConfig: Output<FunctionFileSystemConfigArgs>? = null,
    public val handler: Output<String>? = null,
    public val imageConfig: Output<FunctionImageConfigArgs>? = null,
    public val imageUri: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val layers: Output<List<String>>? = null,
    public val memorySize: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val packageType: Output<String>? = null,
    public val publish: Output<Boolean>? = null,
    @Deprecated(
        message = """
  AWS no longer supports this operation. This attribute now has no effect and will be removed in a
      future major version.
  """,
    )
    public val replaceSecurityGroupsOnDestroy: Output<Boolean>? = null,
    @Deprecated(
        message = """
  AWS no longer supports this operation. This attribute now has no effect and will be removed in a
      future major version.
  """,
    )
    public val replacementSecurityGroupIds: Output<List<String>>? = null,
    public val reservedConcurrentExecutions: Output<Int>? = null,
    public val role: Output<String>? = null,
    public val runtime: Output<Either<String, Runtime>>? = null,
    public val s3Bucket: Output<String>? = null,
    public val s3Key: Output<String>? = null,
    public val s3ObjectVersion: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val snapStart: Output<FunctionSnapStartArgs>? = null,
    public val sourceCodeHash: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeout: Output<Int>? = null,
    public val tracingConfig: Output<FunctionTracingConfigArgs>? = null,
    public val vpcConfig: Output<FunctionVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.FunctionArgs> {
    override fun toJava(): com.pulumi.aws.lambda.FunctionArgs =
        com.pulumi.aws.lambda.FunctionArgs.builder()
            .architectures(architectures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .code(code?.applyValue({ args0 -> args0 }))
            .codeSigningConfigArn(codeSigningConfigArn?.applyValue({ args0 -> args0 }))
            .deadLetterConfig(deadLetterConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environment(environment?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ephemeralStorage(ephemeralStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileSystemConfig(fileSystemConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .handler(handler?.applyValue({ args0 -> args0 }))
            .imageConfig(imageConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageUri(imageUri?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .layers(layers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .memorySize(memorySize?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .packageType(packageType?.applyValue({ args0 -> args0 }))
            .publish(publish?.applyValue({ args0 -> args0 }))
            .replaceSecurityGroupsOnDestroy(replaceSecurityGroupsOnDestroy?.applyValue({ args0 -> args0 }))
            .replacementSecurityGroupIds(
                replacementSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .reservedConcurrentExecutions(reservedConcurrentExecutions?.applyValue({ args0 -> args0 }))
            .role(role?.applyValue({ args0 -> args0 }))
            .runtime(
                runtime?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .s3Bucket(s3Bucket?.applyValue({ args0 -> args0 }))
            .s3Key(s3Key?.applyValue({ args0 -> args0 }))
            .s3ObjectVersion(s3ObjectVersion?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .snapStart(snapStart?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceCodeHash(sourceCodeHash?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .tracingConfig(tracingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FunctionArgs].
 */
@PulumiTagMarker
public class FunctionArgsBuilder internal constructor() {
    private var architectures: Output<List<String>>? = null

    private var code: Output<Archive>? = null

    private var codeSigningConfigArn: Output<String>? = null

    private var deadLetterConfig: Output<FunctionDeadLetterConfigArgs>? = null

    private var description: Output<String>? = null

    private var environment: Output<FunctionEnvironmentArgs>? = null

    private var ephemeralStorage: Output<FunctionEphemeralStorageArgs>? = null

    private var fileSystemConfig: Output<FunctionFileSystemConfigArgs>? = null

    private var handler: Output<String>? = null

    private var imageConfig: Output<FunctionImageConfigArgs>? = null

    private var imageUri: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var layers: Output<List<String>>? = null

    private var memorySize: Output<Int>? = null

    private var name: Output<String>? = null

    private var packageType: Output<String>? = null

    private var publish: Output<Boolean>? = null

    private var replaceSecurityGroupsOnDestroy: Output<Boolean>? = null

    private var replacementSecurityGroupIds: Output<List<String>>? = null

    private var reservedConcurrentExecutions: Output<Int>? = null

    private var role: Output<String>? = null

    private var runtime: Output<Either<String, Runtime>>? = null

    private var s3Bucket: Output<String>? = null

    private var s3Key: Output<String>? = null

    private var s3ObjectVersion: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var snapStart: Output<FunctionSnapStartArgs>? = null

    private var sourceCodeHash: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeout: Output<Int>? = null

    private var tracingConfig: Output<FunctionTracingConfigArgs>? = null

    private var vpcConfig: Output<FunctionVpcConfigArgs>? = null

    /**
     * @param value Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`&#46; Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
     */
    @JvmName("plyqlokoriypvlab")
    public suspend fun architectures(`value`: Output<List<String>>) {
        this.architectures = value
    }

    @JvmName("eiescidfaowfpyfp")
    public suspend fun architectures(vararg values: Output<String>) {
        this.architectures = Output.all(values.asList())
    }

    /**
     * @param values Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`&#46; Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
     */
    @JvmName("jiyaknhsymqdlfnn")
    public suspend fun architectures(values: List<Output<String>>) {
        this.architectures = Output.all(values)
    }

    /**
     * @param value Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
     */
    @JvmName("wyixxrypwmtyejtp")
    public suspend fun code(`value`: Output<Archive>) {
        this.code = value
    }

    /**
     * @param value To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
     */
    @JvmName("sduxovheffwwtgka")
    public suspend fun codeSigningConfigArn(`value`: Output<String>) {
        this.codeSigningConfigArn = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("xtijvpdptercxmru")
    public suspend fun deadLetterConfig(`value`: Output<FunctionDeadLetterConfigArgs>) {
        this.deadLetterConfig = value
    }

    /**
     * @param value Description of what your Lambda Function does.
     */
    @JvmName("quiqyttylxryesif")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("funsxorfoiymftju")
    public suspend fun environment(`value`: Output<FunctionEnvironmentArgs>) {
        this.environment = value
    }

    /**
     * @param value The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
     */
    @JvmName("xjnxecseesocayjx")
    public suspend fun ephemeralStorage(`value`: Output<FunctionEphemeralStorageArgs>) {
        this.ephemeralStorage = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("xyaqnumylnqlxjxr")
    public suspend fun fileSystemConfig(`value`: Output<FunctionFileSystemConfigArgs>) {
        this.fileSystemConfig = value
    }

    /**
     * @param value Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
     */
    @JvmName("bkjflvfcduwuxeyu")
    public suspend fun handler(`value`: Output<String>) {
        this.handler = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("phcpxnejvfqtktee")
    public suspend fun imageConfig(`value`: Output<FunctionImageConfigArgs>) {
        this.imageConfig = value
    }

    /**
     * @param value ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
     */
    @JvmName("dtyjybombridcamh")
    public suspend fun imageUri(`value`: Output<String>) {
        this.imageUri = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
     */
    @JvmName("qqkilewasljuyyks")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
     */
    @JvmName("yodfetvpadtpmoyq")
    public suspend fun layers(`value`: Output<List<String>>) {
        this.layers = value
    }

    @JvmName("lwlwwnsjgdwufkod")
    public suspend fun layers(vararg values: Output<String>) {
        this.layers = Output.all(values.asList())
    }

    /**
     * @param values List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
     */
    @JvmName("wravpglnwifybrnk")
    public suspend fun layers(values: List<Output<String>>) {
        this.layers = Output.all(values)
    }

    /**
     * @param value Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
     */
    @JvmName("bhyfmoxmuakanchy")
    public suspend fun memorySize(`value`: Output<Int>) {
        this.memorySize = value
    }

    /**
     * @param value Unique name for your Lambda Function.
     */
    @JvmName("iarurqbfltiorryy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
     */
    @JvmName("wawrtjcheetikcyo")
    public suspend fun packageType(`value`: Output<String>) {
        this.packageType = value
    }

    /**
     * @param value Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
     */
    @JvmName("tbftlnuappglybwj")
    public suspend fun publish(`value`: Output<Boolean>) {
        this.publish = value
    }

    /**
     * @param value **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
     */
    @Deprecated(
        message = """
  AWS no longer supports this operation. This attribute now has no effect and will be removed in a
      future major version.
  """,
    )
    @JvmName("rvwtjgjcnhhlrwlp")
    public suspend fun replaceSecurityGroupsOnDestroy(`value`: Output<Boolean>) {
        this.replaceSecurityGroupsOnDestroy = value
    }

    /**
     * @param value List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
     */
    @Deprecated(
        message = """
  AWS no longer supports this operation. This attribute now has no effect and will be removed in a
      future major version.
  """,
    )
    @JvmName("uybsaaknthfbeydg")
    public suspend fun replacementSecurityGroupIds(`value`: Output<List<String>>) {
        this.replacementSecurityGroupIds = value
    }

    @JvmName("kyjrmxcxiyymoqmu")
    public suspend fun replacementSecurityGroupIds(vararg values: Output<String>) {
        this.replacementSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
     */
    @Deprecated(
        message = """
  AWS no longer supports this operation. This attribute now has no effect and will be removed in a
      future major version.
  """,
    )
    @JvmName("deupyqtelqovicsc")
    public suspend fun replacementSecurityGroupIds(values: List<Output<String>>) {
        this.replacementSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
     */
    @JvmName("mcrirpqfhiujelax")
    public suspend fun reservedConcurrentExecutions(`value`: Output<Int>) {
        this.reservedConcurrentExecutions = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.
     * The following arguments are optional:
     */
    @JvmName("obpxfsjglflgcvhp")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
     */
    @JvmName("dqtgsbxbncxhmrqq")
    public suspend fun runtime(`value`: Output<Either<String, Runtime>>) {
        this.runtime = value
    }

    /**
     * @param value S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
     */
    @JvmName("suihwcnajycrwvtl")
    public suspend fun s3Bucket(`value`: Output<String>) {
        this.s3Bucket = value
    }

    /**
     * @param value S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
     */
    @JvmName("yenmrvklksexghbk")
    public suspend fun s3Key(`value`: Output<String>) {
        this.s3Key = value
    }

    /**
     * @param value Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
     */
    @JvmName("mrehyvsifqhacnxa")
    public suspend fun s3ObjectVersion(`value`: Output<String>) {
        this.s3ObjectVersion = value
    }

    /**
     * @param value Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
     */
    @JvmName("fenhxgjdhvixcetg")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value Snap start settings block. Detailed below.
     */
    @JvmName("jgqykaefoabxrygf")
    public suspend fun snapStart(`value`: Output<FunctionSnapStartArgs>) {
        this.snapStart = value
    }

    /**
     * @param value Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
     */
    @JvmName("jrnofldkukjbrptj")
    public suspend fun sourceCodeHash(`value`: Output<String>) {
        this.sourceCodeHash = value
    }

    /**
     * @param value Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pmydakatjgamxsgp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
     */
    @JvmName("uhoabkoihdinsuyd")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("hvydogjahdxldaff")
    public suspend fun tracingConfig(`value`: Output<FunctionTracingConfigArgs>) {
        this.tracingConfig = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("xhoipkjnuxsvypkr")
    public suspend fun vpcConfig(`value`: Output<FunctionVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`&#46; Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
     */
    @JvmName("usvcokjlerwbvtvv")
    public suspend fun architectures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architectures = mapped
    }

    /**
     * @param values Instruction set architecture for your Lambda function. Valid values are `["x86_64"]` and `["arm64"]`&#46; Default is `["x86_64"]`. Removing this attribute, function's architecture stay the same.
     */
    @JvmName("uelxvatnpxssmnrg")
    public suspend fun architectures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.architectures = mapped
    }

    /**
     * @param value Path to the function's deployment package within the local filesystem. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified.
     */
    @JvmName("vjsmeedpgeukhrba")
    public suspend fun code(`value`: Archive?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
     */
    @JvmName("rsbldtrgncmrpbst")
    public suspend fun codeSigningConfigArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeSigningConfigArn = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("mladvogmxobpdogo")
    public suspend fun deadLetterConfig(`value`: FunctionDeadLetterConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("ywxglqqspfdrypsr")
    public suspend
    fun deadLetterConfig(argument: suspend FunctionDeadLetterConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionDeadLetterConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deadLetterConfig = mapped
    }

    /**
     * @param value Description of what your Lambda Function does.
     */
    @JvmName("hgulrmmrpyvomskl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("wgeotvcgtdknaeyf")
    public suspend fun environment(`value`: FunctionEnvironmentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("bcsufygwiepvseyf")
    public suspend fun environment(argument: suspend FunctionEnvironmentArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionEnvironmentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.environment = mapped
    }

    /**
     * @param value The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
     */
    @JvmName("fogcmrqqkgfrmmyv")
    public suspend fun ephemeralStorage(`value`: FunctionEphemeralStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralStorage = mapped
    }

    /**
     * @param argument The amount of Ephemeral storage(`/tmp`) to allocate for the Lambda Function in MB. This parameter is used to expand the total amount of Ephemeral storage available, beyond the default amount of `512`MB. Detailed below.
     */
    @JvmName("pixtgpvasuopssjj")
    public suspend
    fun ephemeralStorage(argument: suspend FunctionEphemeralStorageArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionEphemeralStorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ephemeralStorage = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("lrhckhcatljgtouf")
    public suspend fun fileSystemConfig(`value`: FunctionFileSystemConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("xsyimjjyviunsggh")
    public suspend
    fun fileSystemConfig(argument: suspend FunctionFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionFileSystemConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fileSystemConfig = mapped
    }

    /**
     * @param value Function [entrypoint](https://docs.aws.amazon.com/lambda/latest/dg/walkthrough-custom-events-create-test-function.html) in your code.
     */
    @JvmName("yplhrrfsgrbcaywe")
    public suspend fun handler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handler = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("mswkepmsvcpjtrxv")
    public suspend fun imageConfig(`value`: FunctionImageConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("gqbpfkonnpwttfdu")
    public suspend fun imageConfig(argument: suspend FunctionImageConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionImageConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageConfig = mapped
    }

    /**
     * @param value ECR image URI containing the function's deployment package. Exactly one of `filename`, `image_uri`,  or `s3_bucket` must be specified.
     */
    @JvmName("hxeiajegyipngrut")
    public suspend fun imageUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageUri = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the AWS Key Management Service (KMS) key that is used to encrypt environment variables. If this configuration is not provided when environment variables are in use, AWS Lambda uses a default service key. If this configuration is provided when environment variables are not in use, the AWS Lambda API does not save this configuration and the provider will show a perpetual difference of adding the key. To fix the perpetual difference, remove this configuration.
     */
    @JvmName("okvgymxwwombrexh")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
     */
    @JvmName("gprdpigkrwmcpuyc")
    public suspend fun layers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param values List of Lambda Layer Version ARNs (maximum of 5) to attach to your Lambda Function. See [Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
     */
    @JvmName("lcocxvdwmxhqtqoa")
    public suspend fun layers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param value Amount of memory in MB your Lambda Function can use at runtime. Defaults to `128`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
     */
    @JvmName("pglkiowjqiguvwjo")
    public suspend fun memorySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memorySize = mapped
    }

    /**
     * @param value Unique name for your Lambda Function.
     */
    @JvmName("svwctdupnncfosug")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Lambda deployment package type. Valid values are `Zip` and `Image`. Defaults to `Zip`.
     */
    @JvmName("ddvymbkychdoxule")
    public suspend fun packageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageType = mapped
    }

    /**
     * @param value Whether to publish creation/change as new Lambda Function Version. Defaults to `false`.
     */
    @JvmName("msriobcrsvafoxnm")
    public suspend fun publish(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publish = mapped
    }

    /**
     * @param value **AWS no longer supports this operation. This attribute now has no effect and will be removed in a future major version.** Whether to replace the security groups on associated lambda network interfaces upon destruction. Removing these security groups from orphaned network interfaces can speed up security group deletion times by avoiding a dependency on AWS's internal cleanup operations. By default, the ENI security groups will be replaced with the `default` security group in the function's VPC. Set the `replacement_security_group_ids` attribute to use a custom list of security groups for replacement.
     */
    @Deprecated(
        message = """
  AWS no longer supports this operation. This attribute now has no effect and will be removed in a
      future major version.
  """,
    )
    @JvmName("mmhgrgaiogiaolqi")
    public suspend fun replaceSecurityGroupsOnDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replaceSecurityGroupsOnDestroy = mapped
    }

    /**
     * @param value List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
     */
    @Deprecated(
        message = """
  AWS no longer supports this operation. This attribute now has no effect and will be removed in a
      future major version.
  """,
    )
    @JvmName("linstlqahyjkjgth")
    public suspend fun replacementSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replacementSecurityGroupIds = mapped
    }

    /**
     * @param values List of security group IDs to assign to orphaned Lambda function network interfaces upon destruction. `replace_security_groups_on_destroy` must be set to `true` to use this attribute.
     */
    @Deprecated(
        message = """
  AWS no longer supports this operation. This attribute now has no effect and will be removed in a
      future major version.
  """,
    )
    @JvmName("noyquwnrxegdhlfa")
    public suspend fun replacementSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replacementSecurityGroupIds = mapped
    }

    /**
     * @param value Amount of reserved concurrent executions for this lambda function. A value of `0` disables lambda from being triggered and `-1` removes any concurrency limitations. Defaults to Unreserved Concurrency Limits `-1`. See [Managing Concurrency](https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html)
     */
    @JvmName("xanarqeawwwrtcbf")
    public suspend fun reservedConcurrentExecutions(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reservedConcurrentExecutions = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the function's execution role. The role provides the function's identity and access to AWS services and resources.
     * The following arguments are optional:
     */
    @JvmName("nnoalacavdqtlnsc")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
     */
    @JvmName("uqswfiugdsbeanjc")
    public suspend fun runtime(`value`: Either<String, Runtime>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param value Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
     */
    @JvmName("rxuvtpjsxullckfb")
    public fun runtime(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Runtime>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param value Identifier of the function's runtime. See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html#SSS-CreateFunction-request-Runtime) for valid values.
     */
    @JvmName("ygbcmijwyfuniune")
    public fun runtime(`value`: Runtime) {
        val toBeMapped = Either.ofRight<String, Runtime>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param value S3 bucket location containing the function's deployment package. This bucket must reside in the same AWS region where you are creating the Lambda function. Exactly one of `filename`, `image_uri`, or `s3_bucket` must be specified. When `s3_bucket` is set, `s3_key` is required.
     */
    @JvmName("alkwslayswblsfps")
    public suspend fun s3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param value S3 key of an object containing the function's deployment package. When `s3_bucket` is set, `s3_key` is required.
     */
    @JvmName("wrhowhsqpuwvrqnw")
    public suspend fun s3Key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Key = mapped
    }

    /**
     * @param value Object version containing the function's deployment package. Conflicts with `filename` and `image_uri`.
     */
    @JvmName("yucfbavagfjlrydq")
    public suspend fun s3ObjectVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3ObjectVersion = mapped
    }

    /**
     * @param value Set to true if you do not wish the function to be deleted at destroy time, and instead just remove the function from the Pulumi state.
     */
    @JvmName("tarpxytrykgjsbfr")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value Snap start settings block. Detailed below.
     */
    @JvmName("bxxygtofdjfmbnsg")
    public suspend fun snapStart(`value`: FunctionSnapStartArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapStart = mapped
    }

    /**
     * @param argument Snap start settings block. Detailed below.
     */
    @JvmName("kupdrimodpprbjxn")
    public suspend fun snapStart(argument: suspend FunctionSnapStartArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionSnapStartArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snapStart = mapped
    }

    /**
     * @param value Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
     */
    @JvmName("qnibtfvfmcggkupf")
    public suspend fun sourceCodeHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCodeHash = mapped
    }

    /**
     * @param value Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vuaivsakpjsddkfy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wqufcofwcjywoilp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Amount of time your Lambda Function has to run in seconds. Defaults to `3`. See [Limits](https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
     */
    @JvmName("lcaudjtlecplyoka")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("lvifxslktyitlldc")
    public suspend fun tracingConfig(`value`: FunctionTracingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracingConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("moarncjnhwoqvqgf")
    public suspend fun tracingConfig(argument: suspend FunctionTracingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionTracingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tracingConfig = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("kwtrytgoytdnkfpw")
    public suspend fun vpcConfig(`value`: FunctionVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("pcyfbngeaguirwef")
    public suspend fun vpcConfig(argument: suspend FunctionVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FunctionVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): FunctionArgs = FunctionArgs(
        architectures = architectures,
        code = code,
        codeSigningConfigArn = codeSigningConfigArn,
        deadLetterConfig = deadLetterConfig,
        description = description,
        environment = environment,
        ephemeralStorage = ephemeralStorage,
        fileSystemConfig = fileSystemConfig,
        handler = handler,
        imageConfig = imageConfig,
        imageUri = imageUri,
        kmsKeyArn = kmsKeyArn,
        layers = layers,
        memorySize = memorySize,
        name = name,
        packageType = packageType,
        publish = publish,
        replaceSecurityGroupsOnDestroy = replaceSecurityGroupsOnDestroy,
        replacementSecurityGroupIds = replacementSecurityGroupIds,
        reservedConcurrentExecutions = reservedConcurrentExecutions,
        role = role,
        runtime = runtime,
        s3Bucket = s3Bucket,
        s3Key = s3Key,
        s3ObjectVersion = s3ObjectVersion,
        skipDestroy = skipDestroy,
        snapStart = snapStart,
        sourceCodeHash = sourceCodeHash,
        tags = tags,
        timeout = timeout,
        tracingConfig = tracingConfig,
        vpcConfig = vpcConfig,
    )
}
