@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.kotlin.outputs.FunctionEventInvokeConfigDestinationConfig
import com.pulumi.aws.lambda.kotlin.outputs.FunctionEventInvokeConfigDestinationConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FunctionEventInvokeConfig].
 */
@PulumiTagMarker
public class FunctionEventInvokeConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FunctionEventInvokeConfigArgs = FunctionEventInvokeConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FunctionEventInvokeConfigArgsBuilder.() -> Unit) {
        val builder = FunctionEventInvokeConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FunctionEventInvokeConfig {
        val builtJavaResource = com.pulumi.aws.lambda.FunctionEventInvokeConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FunctionEventInvokeConfig(builtJavaResource)
    }
}

/**
 * Manages an asynchronous invocation configuration for a Lambda Function or Alias. More information about asynchronous invocations and the configurable values can be found in the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html).
 * ## Example Usage
 * ### Destination Configuration
 * > **NOTE:** Ensure the Lambda Function IAM Role has necessary permissions for the destination, such as `sqs:SendMessage` or `sns:Publish`, otherwise the API will return a generic `InvalidParameterValueException: The destination ARN arn:PARTITION:SERVICE:REGION:ACCOUNT:RESOURCE is invalid.` error.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfig;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigOnFailureArgs;
 * import com.pulumi.aws.lambda.inputs.FunctionEventInvokeConfigDestinationConfigOnSuccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FunctionEventInvokeConfig("example", FunctionEventInvokeConfigArgs.builder()
 *             .functionName(aws_lambda_alias.example().function_name())
 *             .destinationConfig(FunctionEventInvokeConfigDestinationConfigArgs.builder()
 *                 .onFailure(FunctionEventInvokeConfigDestinationConfigOnFailureArgs.builder()
 *                     .destination(aws_sqs_queue.example().arn())
 *                     .build())
 *                 .onSuccess(FunctionEventInvokeConfigDestinationConfigOnSuccessArgs.builder()
 *                     .destination(aws_sns_topic.example().arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Error Handling Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfig;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FunctionEventInvokeConfig("example", FunctionEventInvokeConfigArgs.builder()
 *             .functionName(aws_lambda_alias.example().function_name())
 *             .maximumEventAgeInSeconds(60)
 *             .maximumRetryAttempts(0)
 *             .build());
 *     }
 * }
 * ```
 * ### Configuration for Alias Name
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfig;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FunctionEventInvokeConfig("example", FunctionEventInvokeConfigArgs.builder()
 *             .functionName(aws_lambda_alias.example().function_name())
 *             .qualifier(aws_lambda_alias.example().name())
 *             .build());
 *     }
 * }
 * ```
 * ### Configuration for Function Latest Unpublished Version
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfig;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FunctionEventInvokeConfig("example", FunctionEventInvokeConfigArgs.builder()
 *             .functionName(aws_lambda_function.example().function_name())
 *             .qualifier("$LATEST")
 *             .build());
 *     }
 * }
 * ```
 * ### Configuration for Function Published Version
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfig;
 * import com.pulumi.aws.lambda.FunctionEventInvokeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FunctionEventInvokeConfig("example", FunctionEventInvokeConfigArgs.builder()
 *             .functionName(aws_lambda_function.example().function_name())
 *             .qualifier(aws_lambda_function.example().version())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * ARN with qualifier:
 * Name without qualifier (all versions and aliases):
 * Name with qualifier:
 * __Using `pulumi import` to import__ Lambda Function Event Invoke Configs using the fully qualified Function name or Amazon Resource Name (ARN). For example:
 * ARN without qualifier (all versions and aliases):
 * ```sh
 *  $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example arn:aws:us-east-1:123456789012:function:my_function
 * ```
 *  ARN with qualifier:
 * ```sh
 *  $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example arn:aws:us-east-1:123456789012:function:my_function:production
 * ```
 *  Name without qualifier (all versions and aliases):
 * ```sh
 *  $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example my_function
 * ```
 *  Name with qualifier:
 * ```sh
 *  $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example my_function:production
 * ```
 *
 */
public class FunctionEventInvokeConfig internal constructor(
    override val javaResource: com.pulumi.aws.lambda.FunctionEventInvokeConfig,
) : KotlinCustomResource(javaResource, FunctionEventInvokeConfigMapper) {
    /**
     * Configuration block with destination configuration. See below for details.
     */
    public val destinationConfig: Output<FunctionEventInvokeConfigDestinationConfig>?
        get() = javaResource.destinationConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name or Amazon Resource Name (ARN) of the Lambda Function, omitting any version or alias qualifier.
     * The following arguments are optional:
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
     */
    public val maximumEventAgeInSeconds: Output<Int>?
        get() = javaResource.maximumEventAgeInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
     */
    public val maximumRetryAttempts: Output<Int>?
        get() = javaResource.maximumRetryAttempts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Lambda Function published version, `$LATEST`, or Lambda Alias name.
     */
    public val qualifier: Output<String>?
        get() = javaResource.qualifier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object FunctionEventInvokeConfigMapper : ResourceMapper<FunctionEventInvokeConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.FunctionEventInvokeConfig::class == javaResource::class

    override fun map(javaResource: Resource): FunctionEventInvokeConfig =
        FunctionEventInvokeConfig(javaResource as com.pulumi.aws.lambda.FunctionEventInvokeConfig)
}

/**
 * @see [FunctionEventInvokeConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FunctionEventInvokeConfig].
 */
public suspend fun functionEventInvokeConfig(
    name: String,
    block: suspend FunctionEventInvokeConfigResourceBuilder.() -> Unit,
): FunctionEventInvokeConfig {
    val builder = FunctionEventInvokeConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FunctionEventInvokeConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun functionEventInvokeConfig(name: String): FunctionEventInvokeConfig {
    val builder = FunctionEventInvokeConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
