@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Invocation].
 */
@PulumiTagMarker
public class InvocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InvocationArgs = InvocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InvocationArgsBuilder.() -> Unit) {
        val builder = InvocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Invocation {
        val builtJavaResource = com.pulumi.aws.lambda.Invocation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Invocation(builtJavaResource)
    }
}

/**
 * Use this resource to invoke a lambda function. The lambda function is invoked with the [RequestResponse](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax) invocation type.
 * > **NOTE:** By default this resource _only_ invokes the function when the arguments call for a create or replace. In other words, after an initial invocation on _apply_, if the arguments do not change, a subsequent _apply_ does not invoke the function again. To dynamically invoke the function, see the `triggers` example below. To always invoke a function on each _apply_, see the `aws.lambda.Invocation` data source. To invoke the lambda function when the Pulumi resource is updated and deleted, see the CRUD Lifecycle Scope example below.
 * > **NOTE:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking an `aws.lambda.Function` with environment variables, the IAM role associated with the function may have been deleted and recreated _after_ the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role, or 2) by using Pulumi to `taint` the function and `apply` your configuration again to recreate the function. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)
 * ## Example Usage
 * ### Dynamic Invocation Example Using Triggers
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Invocation;
 * import com.pulumi.aws.lambda.InvocationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Invocation("example", InvocationArgs.builder()
 *             .functionName(aws_lambda_function.lambda_function_test().function_name())
 *             .triggers(Map.of("redeployment", computeSHA1(serializeJson(
 *                 jsonArray(aws_lambda_function.example().environment())))))
 *             .input(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("key1", "value1"),
 *                     jsonProperty("key2", "value2")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### CRUD Lifecycle Scope
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Invocation;
 * import com.pulumi.aws.lambda.InvocationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Invocation("example", InvocationArgs.builder()
 *             .functionName(aws_lambda_function.lambda_function_test().function_name())
 *             .input(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("key1", "value1"),
 *                     jsonProperty("key2", "value2")
 *                 )))
 *             .lifecycleScope("CRUD")
 *             .build());
 *     }
 * }
 * ```
 */
public class Invocation internal constructor(
    override val javaResource: com.pulumi.aws.lambda.Invocation,
) : KotlinCustomResource(javaResource, InvocationMapper) {
    /**
     * Name of the lambda function.
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * JSON payload to the lambda function.
     * The following arguments are optional:
     */
    public val input: Output<String>
        get() = javaResource.input().applyValue({ args0 -> args0 })

    /**
     * Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
     */
    public val lifecycleScope: Output<String>?
        get() = javaResource.lifecycleScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Qualifier (i.e., version) of the lambda function. Defaults to `$LATEST`.
     */
    public val qualifier: Output<String>?
        get() = javaResource.qualifier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * String result of the lambda function invocation.
     */
    public val result: Output<String>
        get() = javaResource.result().applyValue({ args0 -> args0 })

    public val terraformKey: Output<String>?
        get() = javaResource.terraformKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
     */
    public val triggers: Output<Map<String, String>>?
        get() = javaResource.triggers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object InvocationMapper : ResourceMapper<Invocation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.Invocation::class == javaResource::class

    override fun map(javaResource: Resource): Invocation = Invocation(
        javaResource as
            com.pulumi.aws.lambda.Invocation,
    )
}

/**
 * @see [Invocation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Invocation].
 */
public suspend fun invocation(name: String, block: suspend InvocationResourceBuilder.() -> Unit):
    Invocation {
    val builder = InvocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Invocation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun invocation(name: String): Invocation {
    val builder = InvocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
