@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.InvocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Use this resource to invoke a lambda function. The lambda function is invoked with the [RequestResponse](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax) invocation type.
 * > **NOTE:** By default this resource _only_ invokes the function when the arguments call for a create or replace. In other words, after an initial invocation on _apply_, if the arguments do not change, a subsequent _apply_ does not invoke the function again. To dynamically invoke the function, see the `triggers` example below. To always invoke a function on each _apply_, see the `aws.lambda.Invocation` data source. To invoke the lambda function when the Pulumi resource is updated and deleted, see the CRUD Lifecycle Scope example below.
 * > **NOTE:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking an `aws.lambda.Function` with environment variables, the IAM role associated with the function may have been deleted and recreated _after_ the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role, or 2) by using Pulumi to `taint` the function and `apply` your configuration again to recreate the function. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)
 * ## Example Usage
 * ### Dynamic Invocation Example Using Triggers
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Invocation;
 * import com.pulumi.aws.lambda.InvocationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Invocation("example", InvocationArgs.builder()
 *             .functionName(aws_lambda_function.lambda_function_test().function_name())
 *             .triggers(Map.of("redeployment", computeSHA1(serializeJson(
 *                 jsonArray(aws_lambda_function.example().environment())))))
 *             .input(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("key1", "value1"),
 *                     jsonProperty("key2", "value2")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ### CRUD Lifecycle Scope
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Invocation;
 * import com.pulumi.aws.lambda.InvocationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Invocation("example", InvocationArgs.builder()
 *             .functionName(aws_lambda_function.lambda_function_test().function_name())
 *             .input(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("key1", "value1"),
 *                     jsonProperty("key2", "value2")
 *                 )))
 *             .lifecycleScope("CRUD")
 *             .build());
 *     }
 * }
 * ```
 * @property functionName Name of the lambda function.
 * @property input JSON payload to the lambda function.
 * The following arguments are optional:
 * @property lifecycleScope Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
 * @property qualifier Qualifier (i.e., version) of the lambda function. Defaults to `$LATEST`.
 * @property terraformKey
 * @property triggers Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
 */
public data class InvocationArgs(
    public val functionName: Output<String>? = null,
    public val input: Output<String>? = null,
    public val lifecycleScope: Output<String>? = null,
    public val qualifier: Output<String>? = null,
    public val terraformKey: Output<String>? = null,
    public val triggers: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.InvocationArgs> {
    override fun toJava(): com.pulumi.aws.lambda.InvocationArgs =
        com.pulumi.aws.lambda.InvocationArgs.builder()
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .input(input?.applyValue({ args0 -> args0 }))
            .lifecycleScope(lifecycleScope?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 }))
            .terraformKey(terraformKey?.applyValue({ args0 -> args0 }))
            .triggers(
                triggers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InvocationArgs].
 */
@PulumiTagMarker
public class InvocationArgsBuilder internal constructor() {
    private var functionName: Output<String>? = null

    private var input: Output<String>? = null

    private var lifecycleScope: Output<String>? = null

    private var qualifier: Output<String>? = null

    private var terraformKey: Output<String>? = null

    private var triggers: Output<Map<String, String>>? = null

    /**
     * @param value Name of the lambda function.
     */
    @JvmName("fgubnprtlrexexyj")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value JSON payload to the lambda function.
     * The following arguments are optional:
     */
    @JvmName("yjerfeacjbggdoqc")
    public suspend fun input(`value`: Output<String>) {
        this.input = value
    }

    /**
     * @param value Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
     */
    @JvmName("fecmpknngphdarti")
    public suspend fun lifecycleScope(`value`: Output<String>) {
        this.lifecycleScope = value
    }

    /**
     * @param value Qualifier (i.e., version) of the lambda function. Defaults to `$LATEST`.
     */
    @JvmName("fqgoexiorfnhrsnh")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value
     */
    @JvmName("tlnbqvloperfbvbh")
    public suspend fun terraformKey(`value`: Output<String>) {
        this.terraformKey = value
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
     */
    @JvmName("ddrmctxjcqogvvft")
    public suspend fun triggers(`value`: Output<Map<String, String>>) {
        this.triggers = value
    }

    /**
     * @param value Name of the lambda function.
     */
    @JvmName("elcxftylejgpvwoc")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value JSON payload to the lambda function.
     * The following arguments are optional:
     */
    @JvmName("dxlqdkgcfcdlnyha")
    public suspend fun input(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param value Lifecycle scope of the resource to manage. Valid values are `CREATE_ONLY` and `CRUD`. Defaults to `CREATE_ONLY`. `CREATE_ONLY` will invoke the function only on creation or replacement. `CRUD` will invoke the function on each lifecycle event, and augment the input JSON payload with additional lifecycle information.
     */
    @JvmName("tmsehpaefopsdfbs")
    public suspend fun lifecycleScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleScope = mapped
    }

    /**
     * @param value Qualifier (i.e., version) of the lambda function. Defaults to `$LATEST`.
     */
    @JvmName("svqpfyyejgpliwoy")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    /**
     * @param value
     */
    @JvmName("cnkiqugfvxbtirrb")
    public suspend fun terraformKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terraformKey = mapped
    }

    /**
     * @param value Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
     */
    @JvmName("mcgnefcxivkajvcb")
    public suspend fun triggers(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    /**
     * @param values Map of arbitrary keys and values that, when changed, will trigger a re-invocation.
     */
    @JvmName("vyrwagnjtovrtoen")
    public fun triggers(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggers = mapped
    }

    internal fun build(): InvocationArgs = InvocationArgs(
        functionName = functionName,
        input = input,
        lifecycleScope = lifecycleScope,
        qualifier = qualifier,
        terraformKey = terraformKey,
        triggers = triggers,
    )
}
