@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.asset.Archive
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [LayerVersion].
 */
@PulumiTagMarker
public class LayerVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LayerVersionArgs = LayerVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LayerVersionArgsBuilder.() -> Unit) {
        val builder = LayerVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LayerVersion {
        val builtJavaResource = com.pulumi.aws.lambda.LayerVersion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LayerVersion(builtJavaResource)
    }
}

/**
 * Provides a Lambda Layer Version resource. Lambda Layers allow you to reuse shared bits of code across multiple lambda functions.
 * For information about Lambda Layers and how to use them, see [AWS Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
 * > **NOTE:** Setting `skip_destroy` to `true` means that the AWS Provider will _not_ destroy any layer version, even when running destroy. Layer versions are thus intentional dangling resources that are _not_ managed by the provider and may incur extra expense in your AWS account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.LayerVersion;
 * import com.pulumi.aws.lambda.LayerVersionArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lambdaLayer = new LayerVersion("lambdaLayer", LayerVersionArgs.builder()
 *             .compatibleRuntimes("nodejs16.x")
 *             .code(new FileArchive("lambda_layer_payload.zip"))
 *             .layerName("lambda_layer_name")
 *             .build());
 *     }
 * }
 * ```
 * ## Specifying the Deployment Package
 * AWS Lambda Layers expect source code to be provided as a deployment package whose structure varies depending on which `compatible_runtimes` this layer specifies.
 * See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) for the valid values of `compatible_runtimes`.
 * Once you have created your deployment package you can specify it either directly as a local file (using the `filename` argument) or
 * indirectly via Amazon S3 (using the `s3_bucket`, `s3_key` and `s3_object_version` arguments). When providing the deployment
 * package via S3 it may be useful to use the `aws.s3.BucketObjectv2` resource to upload it.
 * For larger deployment packages it is recommended by Amazon to upload via S3, since the S3 API has better support for uploading large files efficiently.
 * ## Import
 * Using `pulumi import`, import Lambda Layers using `arn`. For example:
 * ```sh
 *  $ pulumi import aws:lambda/layerVersion:LayerVersion test_layer arn:aws:lambda:_REGION_:_ACCOUNT_ID_:layer:_LAYER_NAME_:_LAYER_VERSION_
 * ```
 *
 */
public class LayerVersion internal constructor(
    override val javaResource: com.pulumi.aws.lambda.LayerVersion,
) : KotlinCustomResource(javaResource, LayerVersionMapper) {
    /**
     * ARN of the Lambda Layer with version.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
     */
    public val code: Output<Archive>?
        get() = javaResource.code().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
     */
    public val compatibleArchitectures: Output<List<String>>?
        get() = javaResource.compatibleArchitectures().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
     */
    public val compatibleRuntimes: Output<List<String>>?
        get() = javaResource.compatibleRuntimes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Date this resource was created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Description of what your Lambda Layer does.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the Lambda Layer without version.
     */
    public val layerArn: Output<String>
        get() = javaResource.layerArn().applyValue({ args0 -> args0 })

    /**
     * Unique name for your Lambda Layer
     * The following arguments are optional:
     */
    public val layerName: Output<String>
        get() = javaResource.layerName().applyValue({ args0 -> args0 })

    /**
     * License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
     */
    public val licenseInfo: Output<String>?
        get() = javaResource.licenseInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
     */
    public val s3Bucket: Output<String>?
        get() = javaResource.s3Bucket().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * S3 key of an object containing the function's deployment package. Conflicts with `filename`.
     */
    public val s3Key: Output<String>?
        get() = javaResource.s3Key().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Object version containing the function's deployment package. Conflicts with `filename`.
     */
    public val s3ObjectVersion: Output<String>?
        get() = javaResource.s3ObjectVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of a signing job.
     */
    public val signingJobArn: Output<String>
        get() = javaResource.signingJobArn().applyValue({ args0 -> args0 })

    /**
     * ARN for a signing profile version.
     */
    public val signingProfileVersionArn: Output<String>
        get() = javaResource.signingProfileVersionArn().applyValue({ args0 -> args0 })

    /**
     * Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
     */
    public val skipDestroy: Output<Boolean>?
        get() = javaResource.skipDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
     */
    public val sourceCodeHash: Output<String>
        get() = javaResource.sourceCodeHash().applyValue({ args0 -> args0 })

    /**
     * Size in bytes of the function .zip file.
     */
    public val sourceCodeSize: Output<Int>
        get() = javaResource.sourceCodeSize().applyValue({ args0 -> args0 })

    /**
     * Lambda Layer version.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object LayerVersionMapper : ResourceMapper<LayerVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.LayerVersion::class == javaResource::class

    override fun map(javaResource: Resource): LayerVersion = LayerVersion(
        javaResource as
            com.pulumi.aws.lambda.LayerVersion,
    )
}

/**
 * @see [LayerVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LayerVersion].
 */
public suspend fun layerVersion(
    name: String,
    block: suspend LayerVersionResourceBuilder.() -> Unit,
): LayerVersion {
    val builder = LayerVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LayerVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun layerVersion(name: String): LayerVersion {
    val builder = LayerVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
