@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.asset.Archive
import com.pulumi.aws.lambda.LayerVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Lambda Layer Version resource. Lambda Layers allow you to reuse shared bits of code across multiple lambda functions.
 * For information about Lambda Layers and how to use them, see [AWS Lambda Layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
 * > **NOTE:** Setting `skip_destroy` to `true` means that the AWS Provider will _not_ destroy any layer version, even when running destroy. Layer versions are thus intentional dangling resources that are _not_ managed by the provider and may incur extra expense in your AWS account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.LayerVersion;
 * import com.pulumi.aws.lambda.LayerVersionArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lambdaLayer = new LayerVersion("lambdaLayer", LayerVersionArgs.builder()
 *             .compatibleRuntimes("nodejs16.x")
 *             .code(new FileArchive("lambda_layer_payload.zip"))
 *             .layerName("lambda_layer_name")
 *             .build());
 *     }
 * }
 * ```
 * ## Specifying the Deployment Package
 * AWS Lambda Layers expect source code to be provided as a deployment package whose structure varies depending on which `compatible_runtimes` this layer specifies.
 * See [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) for the valid values of `compatible_runtimes`.
 * Once you have created your deployment package you can specify it either directly as a local file (using the `filename` argument) or
 * indirectly via Amazon S3 (using the `s3_bucket`, `s3_key` and `s3_object_version` arguments). When providing the deployment
 * package via S3 it may be useful to use the `aws.s3.BucketObjectv2` resource to upload it.
 * For larger deployment packages it is recommended by Amazon to upload via S3, since the S3 API has better support for uploading large files efficiently.
 * ## Import
 * Using `pulumi import`, import Lambda Layers using `arn`. For example:
 * ```sh
 *  $ pulumi import aws:lambda/layerVersion:LayerVersion test_layer arn:aws:lambda:_REGION_:_ACCOUNT_ID_:layer:_LAYER_NAME_:_LAYER_VERSION_
 * ```
 * @property code Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
 * @property compatibleArchitectures List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
 * @property compatibleRuntimes List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
 * @property description Description of what your Lambda Layer does.
 * @property layerName Unique name for your Lambda Layer
 * The following arguments are optional:
 * @property licenseInfo License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
 * @property s3Bucket S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
 * @property s3Key S3 key of an object containing the function's deployment package. Conflicts with `filename`.
 * @property s3ObjectVersion Object version containing the function's deployment package. Conflicts with `filename`.
 * @property skipDestroy Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
 * @property sourceCodeHash Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
 */
public data class LayerVersionArgs(
    public val code: Output<Archive>? = null,
    public val compatibleArchitectures: Output<List<String>>? = null,
    public val compatibleRuntimes: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val layerName: Output<String>? = null,
    public val licenseInfo: Output<String>? = null,
    public val s3Bucket: Output<String>? = null,
    public val s3Key: Output<String>? = null,
    public val s3ObjectVersion: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val sourceCodeHash: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.LayerVersionArgs> {
    override fun toJava(): com.pulumi.aws.lambda.LayerVersionArgs =
        com.pulumi.aws.lambda.LayerVersionArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .compatibleArchitectures(
                compatibleArchitectures?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .compatibleRuntimes(compatibleRuntimes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .layerName(layerName?.applyValue({ args0 -> args0 }))
            .licenseInfo(licenseInfo?.applyValue({ args0 -> args0 }))
            .s3Bucket(s3Bucket?.applyValue({ args0 -> args0 }))
            .s3Key(s3Key?.applyValue({ args0 -> args0 }))
            .s3ObjectVersion(s3ObjectVersion?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .sourceCodeHash(sourceCodeHash?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LayerVersionArgs].
 */
@PulumiTagMarker
public class LayerVersionArgsBuilder internal constructor() {
    private var code: Output<Archive>? = null

    private var compatibleArchitectures: Output<List<String>>? = null

    private var compatibleRuntimes: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var layerName: Output<String>? = null

    private var licenseInfo: Output<String>? = null

    private var s3Bucket: Output<String>? = null

    private var s3Key: Output<String>? = null

    private var s3ObjectVersion: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var sourceCodeHash: Output<String>? = null

    /**
     * @param value Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
     */
    @JvmName("rvmixbdyybsrinyf")
    public suspend fun code(`value`: Output<Archive>) {
        this.code = value
    }

    /**
     * @param value List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
     */
    @JvmName("uiichoqxogwfbtpb")
    public suspend fun compatibleArchitectures(`value`: Output<List<String>>) {
        this.compatibleArchitectures = value
    }

    @JvmName("fhpahwtpbfxxvysc")
    public suspend fun compatibleArchitectures(vararg values: Output<String>) {
        this.compatibleArchitectures = Output.all(values.asList())
    }

    /**
     * @param values List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
     */
    @JvmName("murlhhjgvgcaccxv")
    public suspend fun compatibleArchitectures(values: List<Output<String>>) {
        this.compatibleArchitectures = Output.all(values)
    }

    /**
     * @param value List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
     */
    @JvmName("nagncyccrktdbxng")
    public suspend fun compatibleRuntimes(`value`: Output<List<String>>) {
        this.compatibleRuntimes = value
    }

    @JvmName("xkgtvuwtfomugtlx")
    public suspend fun compatibleRuntimes(vararg values: Output<String>) {
        this.compatibleRuntimes = Output.all(values.asList())
    }

    /**
     * @param values List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
     */
    @JvmName("uhmevbwqshapxmyp")
    public suspend fun compatibleRuntimes(values: List<Output<String>>) {
        this.compatibleRuntimes = Output.all(values)
    }

    /**
     * @param value Description of what your Lambda Layer does.
     */
    @JvmName("msuoyqtdgawixsfy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique name for your Lambda Layer
     * The following arguments are optional:
     */
    @JvmName("mwcstqiogtrgfxlj")
    public suspend fun layerName(`value`: Output<String>) {
        this.layerName = value
    }

    /**
     * @param value License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
     */
    @JvmName("nmqtjkgafxnflyqh")
    public suspend fun licenseInfo(`value`: Output<String>) {
        this.licenseInfo = value
    }

    /**
     * @param value S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
     */
    @JvmName("vocysyvnaqbiqway")
    public suspend fun s3Bucket(`value`: Output<String>) {
        this.s3Bucket = value
    }

    /**
     * @param value S3 key of an object containing the function's deployment package. Conflicts with `filename`.
     */
    @JvmName("scwgawfeumevpfff")
    public suspend fun s3Key(`value`: Output<String>) {
        this.s3Key = value
    }

    /**
     * @param value Object version containing the function's deployment package. Conflicts with `filename`.
     */
    @JvmName("vxkryuodfpumfsqs")
    public suspend fun s3ObjectVersion(`value`: Output<String>) {
        this.s3ObjectVersion = value
    }

    /**
     * @param value Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
     */
    @JvmName("kvmvhcugqnvkebyu")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
     */
    @JvmName("gnxbqcnaslrtcswu")
    public suspend fun sourceCodeHash(`value`: Output<String>) {
        this.sourceCodeHash = value
    }

    /**
     * @param value Path to the function's deployment package within the local filesystem. If defined, The `s3_`-prefixed options cannot be used.
     */
    @JvmName("metihmadcilkcuvg")
    public suspend fun code(`value`: Archive?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
     */
    @JvmName("rdqoaimawrjphcho")
    public suspend fun compatibleArchitectures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compatibleArchitectures = mapped
    }

    /**
     * @param values List of [Architectures](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleArchitectures) this layer is compatible with. Currently `x86_64` and `arm64` can be specified.
     */
    @JvmName("caspojlbjolrwpyp")
    public suspend fun compatibleArchitectures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compatibleArchitectures = mapped
    }

    /**
     * @param value List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
     */
    @JvmName("ifciijirwkosjsci")
    public suspend fun compatibleRuntimes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compatibleRuntimes = mapped
    }

    /**
     * @param values List of [Runtimes](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-CompatibleRuntimes) this layer is compatible with. Up to 15 runtimes can be specified.
     */
    @JvmName("vallfhgssbppussy")
    public suspend fun compatibleRuntimes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compatibleRuntimes = mapped
    }

    /**
     * @param value Description of what your Lambda Layer does.
     */
    @JvmName("oajjqeiirfmheyxc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique name for your Lambda Layer
     * The following arguments are optional:
     */
    @JvmName("rvkuoqdoqpsvokjs")
    public suspend fun layerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layerName = mapped
    }

    /**
     * @param value License info for your Lambda Layer. See [License Info](https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html#SSS-PublishLayerVersion-request-LicenseInfo).
     */
    @JvmName("xjyfghfnkbdgwhup")
    public suspend fun licenseInfo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseInfo = mapped
    }

    /**
     * @param value S3 bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same AWS region where you are creating the Lambda function.
     */
    @JvmName("norcrjmevucmgowp")
    public suspend fun s3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param value S3 key of an object containing the function's deployment package. Conflicts with `filename`.
     */
    @JvmName("asemwfetxhyiopig")
    public suspend fun s3Key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Key = mapped
    }

    /**
     * @param value Object version containing the function's deployment package. Conflicts with `filename`.
     */
    @JvmName("jstoutvtdsxrabrx")
    public suspend fun s3ObjectVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3ObjectVersion = mapped
    }

    /**
     * @param value Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
     */
    @JvmName("hwfxihexqbbrixns")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the package file specified with either `filename` or `s3_key`.
     */
    @JvmName("furwppggdrupfmqf")
    public suspend fun sourceCodeHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCodeHash = mapped
    }

    internal fun build(): LayerVersionArgs = LayerVersionArgs(
        code = code,
        compatibleArchitectures = compatibleArchitectures,
        compatibleRuntimes = compatibleRuntimes,
        description = description,
        layerName = layerName,
        licenseInfo = licenseInfo,
        s3Bucket = s3Bucket,
        s3Key = s3Key,
        s3ObjectVersion = s3ObjectVersion,
        skipDestroy = skipDestroy,
        sourceCodeHash = sourceCodeHash,
    )
}
