@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LayerVersionPermission].
 */
@PulumiTagMarker
public class LayerVersionPermissionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LayerVersionPermissionArgs = LayerVersionPermissionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LayerVersionPermissionArgsBuilder.() -> Unit) {
        val builder = LayerVersionPermissionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LayerVersionPermission {
        val builtJavaResource = com.pulumi.aws.lambda.LayerVersionPermission(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LayerVersionPermission(builtJavaResource)
    }
}

/**
 * Provides a Lambda Layer Version Permission resource. It allows you to share you own Lambda Layers to another account by account ID, to all accounts in AWS organization or even to all AWS accounts.
 * For information about Lambda Layer Permissions and how to use them, see [Using Resource-based Policies for AWS Lambda][1]
 * > **NOTE:** Setting `skip_destroy` to `true` means that the AWS Provider will _not_ destroy any layer version permission, even when running `pulumi destroy`. Layer version permissions are thus intentional dangling resources that are _not_ managed by Pulumi and may incur extra expense in your AWS account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.LayerVersionPermission;
 * import com.pulumi.aws.lambda.LayerVersionPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lambdaLayerPermission = new LayerVersionPermission("lambdaLayerPermission", LayerVersionPermissionArgs.builder()
 *             .action("lambda:GetLayerVersion")
 *             .layerName("arn:aws:lambda:us-west-2:123456654321:layer:test_layer1")
 *             .principal("111111111111")
 *             .statementId("dev-account")
 *             .versionNumber(1)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lambda Layer Permissions using `layer_name` and `version_number`, separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:lambda/layerVersionPermission:LayerVersionPermission example arn:aws:lambda:us-west-2:123456654321:layer:test_layer1,1
 * ```
 *
 */
public class LayerVersionPermission internal constructor(
    override val javaResource: com.pulumi.aws.lambda.LayerVersionPermission,
) : KotlinCustomResource(javaResource, LayerVersionPermissionMapper) {
    /**
     * Action, which will be allowed. `lambda:GetLayerVersion` value is suggested by AWS documantation.
     */
    public val action: Output<String>
        get() = javaResource.action().applyValue({ args0 -> args0 })

    /**
     * The name or ARN of the Lambda Layer, which you want to grant access to.
     */
    public val layerName: Output<String>
        get() = javaResource.layerName().applyValue({ args0 -> args0 })

    /**
     * An identifier of AWS Organization, which should be able to use your Lambda Layer. `principal` should be equal to `*` if `organization_id` provided.
     */
    public val organizationId: Output<String>?
        get() = javaResource.organizationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Full Lambda Layer Permission policy.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * AWS account ID which should be able to use your Lambda Layer. `*` can be used here, if you want to share your Lambda Layer widely.
     */
    public val principal: Output<String>
        get() = javaResource.principal().applyValue({ args0 -> args0 })

    /**
     * A unique identifier for the current revision of the policy.
     */
    public val revisionId: Output<String>
        get() = javaResource.revisionId().applyValue({ args0 -> args0 })

    /**
     * Whether to retain the old version of a previously deployed Lambda Layer. Default is `false`. When this is not set to `true`, changing any of `compatible_architectures`, `compatible_runtimes`, `description`, `filename`, `layer_name`, `license_info`, `s3_bucket`, `s3_key`, `s3_object_version`, or `source_code_hash` forces deletion of the existing layer version and creation of a new layer version.
     */
    public val skipDestroy: Output<Boolean>?
        get() = javaResource.skipDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of Lambda Layer Permission, for example `dev-account` - human readable note about what is this permission for.
     */
    public val statementId: Output<String>
        get() = javaResource.statementId().applyValue({ args0 -> args0 })

    /**
     * Version of Lambda Layer, which you want to grant access to. Note: permissions only apply to a single version of a layer.
     */
    public val versionNumber: Output<Int>
        get() = javaResource.versionNumber().applyValue({ args0 -> args0 })
}

public object LayerVersionPermissionMapper : ResourceMapper<LayerVersionPermission> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lambda.LayerVersionPermission::class == javaResource::class

    override fun map(javaResource: Resource): LayerVersionPermission =
        LayerVersionPermission(javaResource as com.pulumi.aws.lambda.LayerVersionPermission)
}

/**
 * @see [LayerVersionPermission].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LayerVersionPermission].
 */
public suspend fun layerVersionPermission(
    name: String,
    block: suspend LayerVersionPermissionResourceBuilder.() -> Unit,
): LayerVersionPermission {
    val builder = LayerVersionPermissionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LayerVersionPermission].
 * @param name The _unique_ name of the resulting resource.
 */
public fun layerVersionPermission(name: String): LayerVersionPermission {
    val builder = LayerVersionPermissionResourceBuilder()
    builder.name(name)
    return builder.build()
}
