@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.PermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gives an external source (like an EventBridge Rule, SNS, or S3) permission to access the Lambda function.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.lambda.Alias;
 * import com.pulumi.aws.lambda.AliasArgs;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iamForLambda = new Role("iamForLambda", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "lambda.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var testLambda = new Function("testLambda", FunctionArgs.builder()
 *             .code(new FileArchive("lambdatest.zip"))
 *             .role(iamForLambda.arn())
 *             .handler("exports.handler")
 *             .runtime("nodejs16.x")
 *             .build());
 *         var testAlias = new Alias("testAlias", AliasArgs.builder()
 *             .description("a sample description")
 *             .functionName(testLambda.name())
 *             .functionVersion("$LATEST")
 *             .build());
 *         var allowCloudwatch = new Permission("allowCloudwatch", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(testLambda.name())
 *             .principal("events.amazonaws.com")
 *             .sourceArn("arn:aws:events:eu-west-1:111122223333:rule/RunDaily")
 *             .qualifier(testAlias.name())
 *             .build());
 *     }
 * }
 * ```
 * ### With SNS
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.sns.TopicSubscription;
 * import com.pulumi.aws.sns.TopicSubscriptionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultTopic = new Topic("defaultTopic");
 *         var defaultRole = new Role("defaultRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "lambda.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var func = new Function("func", FunctionArgs.builder()
 *             .code(new FileArchive("lambdatest.zip"))
 *             .role(defaultRole.arn())
 *             .handler("exports.handler")
 *             .runtime("python3.7")
 *             .build());
 *         var withSns = new Permission("withSns", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(func.name())
 *             .principal("sns.amazonaws.com")
 *             .sourceArn(defaultTopic.arn())
 *             .build());
 *         var lambda = new TopicSubscription("lambda", TopicSubscriptionArgs.builder()
 *             .topic(defaultTopic.arn())
 *             .protocol("lambda")
 *             .endpoint(func.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### With API Gateway REST API
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var lambdaPermission = new Permission("lambdaPermission", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function("MyDemoFunction")
 *             .principal("apigateway.amazonaws.com")
 *             .sourceArn(myDemoAPI.executionArn().applyValue(executionArn -> String.format("%s/*", executionArn)))
 *             .build());
 *     }
 * }
 * ```
 * ### With CloudWatch Log Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import com.pulumi.aws.cloudwatch.LogSubscriptionFilter;
 * import com.pulumi.aws.cloudwatch.LogSubscriptionFilterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultLogGroup = new LogGroup("defaultLogGroup");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var defaultRole = new Role("defaultRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var loggingFunction = new Function("loggingFunction", FunctionArgs.builder()
 *             .code(new FileArchive("lamba_logging.zip"))
 *             .handler("exports.handler")
 *             .role(defaultRole.arn())
 *             .runtime("python3.7")
 *             .build());
 *         var loggingPermission = new Permission("loggingPermission", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(loggingFunction.name())
 *             .principal("logs.eu-west-1.amazonaws.com")
 *             .sourceArn(defaultLogGroup.arn().applyValue(arn -> String.format("%s:*", arn)))
 *             .build());
 *         var loggingLogSubscriptionFilter = new LogSubscriptionFilter("loggingLogSubscriptionFilter", LogSubscriptionFilterArgs.builder()
 *             .destinationArn(loggingFunction.arn())
 *             .filterPattern("")
 *             .logGroup(defaultLogGroup.name())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(loggingPermission)
 *                 .build());
 *     }
 * }
 * ```
 * ### With Cross-Account Invocation Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.FunctionUrl;
 * import com.pulumi.aws.lambda.FunctionUrlArgs;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var urlFunctionUrl = new FunctionUrl("urlFunctionUrl", FunctionUrlArgs.builder()
 *             .functionName(aws_lambda_function.example().function_name())
 *             .authorizationType("AWS_IAM")
 *             .build());
 *         var urlPermission = new Permission("urlPermission", PermissionArgs.builder()
 *             .action("lambda:InvokeFunctionUrl")
 *             .function(aws_lambda_function.example().function_name())
 *             .principal("arn:aws:iam::444455556666:role/example")
 *             .sourceAccount("444455556666")
 *             .functionUrlAuthType("AWS_IAM")
 *             .build());
 *     }
 * }
 * ```
 * ### With `replace_triggered_by` Lifecycle Configuration
 * If omitting the `qualifier` argument (which forces re-creation each time a function version is published), a `lifecycle` block can be used to ensure permissions are re-applied on any change to the underlying function.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.Permission;
 * import com.pulumi.aws.lambda.PermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var logging = new Permission("logging", PermissionArgs.builder()
 *             .action("lambda:InvokeFunction")
 *             .function(aws_lambda_function.example().function_name())
 *             .principal("events.amazonaws.com")
 *             .sourceArn("arn:aws:events:eu-west-1:111122223333:rule/RunDaily")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lambda permission statements using function_name/statement_id with an optional qualifier. For example:
 * ```sh
 *  $ pulumi import aws:lambda/permission:Permission test_lambda_permission my_test_lambda_function/AllowExecutionFromCloudWatch
 * ```
 *  ```sh
 *  $ pulumi import aws:lambda/permission:Permission test_lambda_permission my_test_lambda_function:qualifier_name/AllowExecutionFromCloudWatch
 * ```
 * @property action The AWS Lambda action you want to allow in this statement. (e.g., `lambda:InvokeFunction`)
 * @property eventSourceToken The Event Source Token to validate.  Used with [Alexa Skills](https://developer.amazon.com/docs/custom-skills/host-a-custom-skill-as-an-aws-lambda-function.html#use-aws-cli).
 * @property function Name of the Lambda function whose resource policy you are updating
 * @property functionUrlAuthType Lambda Function URLs [authentication type](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html). Valid values are: `AWS_IAM` or `NONE`. Only supported for `lambda:InvokeFunctionUrl` action.
 * @property principal The principal who is getting this permission e.g., `s3.amazonaws.com`, an AWS account ID, or AWS IAM principal, or AWS service principal such as `events.amazonaws.com` or `sns.amazonaws.com`.
 * @property principalOrgId The identifier for your organization in AWS Organizations. Use this to grant permissions to all the AWS accounts under this organization.
 * [1]: https://developer.amazon.com/docs/custom-skills/host-a-custom-skill-as-an-aws-lambda-function.html#use-aws-cli
 * [2]: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-control-access-using-iam-policies-to-invoke-api.html
 * [3]: https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html
 * @property qualifier Query parameter to specify function version or alias name. The permission will then apply to the specific qualified ARN e.g., `arn:aws:lambda:aws-region:acct-id:function:function-name:2`
 * @property sourceAccount This parameter is used when allowing cross-account access, or for S3 and SES. The AWS account ID (without a hyphen) of the source owner.
 * @property sourceArn When the principal is an AWS service, the ARN of the specific resource within that service to grant permission to.
 * Without this, any resource from `principal` will be granted permission – even if that resource is from another account.
 * For S3, this should be the ARN of the S3 Bucket.
 * For EventBridge events, this should be the ARN of the EventBridge Rule.
 * For API Gateway, this should be the ARN of the API, as described [here](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-control-access-using-iam-policies-to-invoke-api.html).
 * @property statementId A unique statement identifier. By default generated by the provider.
 * @property statementIdPrefix A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
 * */
 */
public data class PermissionArgs(
    public val action: Output<String>? = null,
    public val eventSourceToken: Output<String>? = null,
    public val function: Output<String>? = null,
    public val functionUrlAuthType: Output<String>? = null,
    public val principal: Output<String>? = null,
    public val principalOrgId: Output<String>? = null,
    public val qualifier: Output<String>? = null,
    public val sourceAccount: Output<String>? = null,
    public val sourceArn: Output<String>? = null,
    public val statementId: Output<String>? = null,
    public val statementIdPrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.PermissionArgs> {
    override fun toJava(): com.pulumi.aws.lambda.PermissionArgs =
        com.pulumi.aws.lambda.PermissionArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .eventSourceToken(eventSourceToken?.applyValue({ args0 -> args0 }))
            .function(function?.applyValue({ args0 -> args0 }))
            .functionUrlAuthType(functionUrlAuthType?.applyValue({ args0 -> args0 }))
            .principal(principal?.applyValue({ args0 -> args0 }))
            .principalOrgId(principalOrgId?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 }))
            .sourceAccount(sourceAccount?.applyValue({ args0 -> args0 }))
            .sourceArn(sourceArn?.applyValue({ args0 -> args0 }))
            .statementId(statementId?.applyValue({ args0 -> args0 }))
            .statementIdPrefix(statementIdPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionArgs].
 */
@PulumiTagMarker
public class PermissionArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var eventSourceToken: Output<String>? = null

    private var function: Output<String>? = null

    private var functionUrlAuthType: Output<String>? = null

    private var principal: Output<String>? = null

    private var principalOrgId: Output<String>? = null

    private var qualifier: Output<String>? = null

    private var sourceAccount: Output<String>? = null

    private var sourceArn: Output<String>? = null

    private var statementId: Output<String>? = null

    private var statementIdPrefix: Output<String>? = null

    /**
     * @param value The AWS Lambda action you want to allow in this statement. (e.g., `lambda:InvokeFunction`)
     */
    @JvmName("sghwrlphnymksfqb")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The Event Source Token to validate.  Used with [Alexa Skills](https://developer.amazon.com/docs/custom-skills/host-a-custom-skill-as-an-aws-lambda-function.html#use-aws-cli).
     */
    @JvmName("slrkaaluhnotnyud")
    public suspend fun eventSourceToken(`value`: Output<String>) {
        this.eventSourceToken = value
    }

    /**
     * @param value Name of the Lambda function whose resource policy you are updating
     */
    @JvmName("ptwaiqypboqxymjv")
    public suspend fun function(`value`: Output<String>) {
        this.function = value
    }

    /**
     * @param value Lambda Function URLs [authentication type](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html). Valid values are: `AWS_IAM` or `NONE`. Only supported for `lambda:InvokeFunctionUrl` action.
     */
    @JvmName("gpuipfoucoxsejpy")
    public suspend fun functionUrlAuthType(`value`: Output<String>) {
        this.functionUrlAuthType = value
    }

    /**
     * @param value The principal who is getting this permission e.g., `s3.amazonaws.com`, an AWS account ID, or AWS IAM principal, or AWS service principal such as `events.amazonaws.com` or `sns.amazonaws.com`.
     */
    @JvmName("qmvpdxdsaukmsquy")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value The identifier for your organization in AWS Organizations. Use this to grant permissions to all the AWS accounts under this organization.
     * [1]: https://developer.amazon.com/docs/custom-skills/host-a-custom-skill-as-an-aws-lambda-function.html#use-aws-cli
     * [2]: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-control-access-using-iam-policies-to-invoke-api.html
     * [3]: https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html
     */
    @JvmName("salltqlaxgywiqxm")
    public suspend fun principalOrgId(`value`: Output<String>) {
        this.principalOrgId = value
    }

    /**
     * @param value Query parameter to specify function version or alias name. The permission will then apply to the specific qualified ARN e.g., `arn:aws:lambda:aws-region:acct-id:function:function-name:2`
     */
    @JvmName("gxjhumkvuicugqja")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value This parameter is used when allowing cross-account access, or for S3 and SES. The AWS account ID (without a hyphen) of the source owner.
     */
    @JvmName("ooeoxkmrqfbfqqih")
    public suspend fun sourceAccount(`value`: Output<String>) {
        this.sourceAccount = value
    }

    /**
     * @param value When the principal is an AWS service, the ARN of the specific resource within that service to grant permission to.
     * Without this, any resource from `principal` will be granted permission – even if that resource is from another account.
     * For S3, this should be the ARN of the S3 Bucket.
     * For EventBridge events, this should be the ARN of the EventBridge Rule.
     * For API Gateway, this should be the ARN of the API, as described [here](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-control-access-using-iam-policies-to-invoke-api.html).
     */
    @JvmName("irbuqqjwonkbngtj")
    public suspend fun sourceArn(`value`: Output<String>) {
        this.sourceArn = value
    }

    /**
     * @param value A unique statement identifier. By default generated by the provider.
     */
    @JvmName("rwgcnosrknwflsse")
    public suspend fun statementId(`value`: Output<String>) {
        this.statementId = value
    }

    /**
     * @param value A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
     */
    @JvmName("airsktthfxodcrjr")
    public suspend fun statementIdPrefix(`value`: Output<String>) {
        this.statementIdPrefix = value
    }

    /**
     * @param value The AWS Lambda action you want to allow in this statement. (e.g., `lambda:InvokeFunction`)
     */
    @JvmName("lndvbmqqmtdaduil")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The Event Source Token to validate.  Used with [Alexa Skills](https://developer.amazon.com/docs/custom-skills/host-a-custom-skill-as-an-aws-lambda-function.html#use-aws-cli).
     */
    @JvmName("inwsiawrirvbtkrh")
    public suspend fun eventSourceToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSourceToken = mapped
    }

    /**
     * @param value Name of the Lambda function whose resource policy you are updating
     */
    @JvmName("vljvclxakspkqtde")
    public suspend fun function(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.function = mapped
    }

    /**
     * @param value Lambda Function URLs [authentication type](https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html). Valid values are: `AWS_IAM` or `NONE`. Only supported for `lambda:InvokeFunctionUrl` action.
     */
    @JvmName("mqlviwpdwhukirhg")
    public suspend fun functionUrlAuthType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionUrlAuthType = mapped
    }

    /**
     * @param value The principal who is getting this permission e.g., `s3.amazonaws.com`, an AWS account ID, or AWS IAM principal, or AWS service principal such as `events.amazonaws.com` or `sns.amazonaws.com`.
     */
    @JvmName("uylhfprjwctkrqbj")
    public suspend fun principal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    /**
     * @param value The identifier for your organization in AWS Organizations. Use this to grant permissions to all the AWS accounts under this organization.
     * [1]: https://developer.amazon.com/docs/custom-skills/host-a-custom-skill-as-an-aws-lambda-function.html#use-aws-cli
     * [2]: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-control-access-using-iam-policies-to-invoke-api.html
     * [3]: https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html
     */
    @JvmName("hutrfnieifaysdjh")
    public suspend fun principalOrgId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalOrgId = mapped
    }

    /**
     * @param value Query parameter to specify function version or alias name. The permission will then apply to the specific qualified ARN e.g., `arn:aws:lambda:aws-region:acct-id:function:function-name:2`
     */
    @JvmName("myxfcbvtfrbprbet")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    /**
     * @param value This parameter is used when allowing cross-account access, or for S3 and SES. The AWS account ID (without a hyphen) of the source owner.
     */
    @JvmName("axyscoyglfxjdtct")
    public suspend fun sourceAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAccount = mapped
    }

    /**
     * @param value When the principal is an AWS service, the ARN of the specific resource within that service to grant permission to.
     * Without this, any resource from `principal` will be granted permission – even if that resource is from another account.
     * For S3, this should be the ARN of the S3 Bucket.
     * For EventBridge events, this should be the ARN of the EventBridge Rule.
     * For API Gateway, this should be the ARN of the API, as described [here](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-control-access-using-iam-policies-to-invoke-api.html).
     */
    @JvmName("ldybpolcacpsbfow")
    public suspend fun sourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceArn = mapped
    }

    /**
     * @param value A unique statement identifier. By default generated by the provider.
     */
    @JvmName("vduqkfogklmpqsii")
    public suspend fun statementId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementId = mapped
    }

    /**
     * @param value A statement identifier prefix. The provider will generate a unique suffix. Conflicts with `statement_id`.
     */
    @JvmName("pvrgtcccevdxqtvy")
    public suspend fun statementIdPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statementIdPrefix = mapped
    }

    internal fun build(): PermissionArgs = PermissionArgs(
        action = action,
        eventSourceToken = eventSourceToken,
        function = function,
        functionUrlAuthType = functionUrlAuthType,
        principal = principal,
        principalOrgId = principalOrgId,
        qualifier = qualifier,
        sourceAccount = sourceAccount,
        sourceArn = sourceArn,
        statementId = statementId,
        statementIdPrefix = statementIdPrefix,
    )
}
