@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin

import com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Lambda Provisioned Concurrency Configuration.
 * > **NOTE:** Setting `skip_destroy` to `true` means that the AWS Provider will _not_ destroy a provisioned concurrency configuration, even when running `pulumi destroy`. The configuration is thus an intentional dangling resource that is _not_ managed by Pulumi and may incur extra expense in your AWS account.
 * ## Example Usage
 * ### Alias Name
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfig;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisionedConcurrencyConfig("example", ProvisionedConcurrencyConfigArgs.builder()
 *             .functionName(aws_lambda_alias.example().function_name())
 *             .provisionedConcurrentExecutions(1)
 *             .qualifier(aws_lambda_alias.example().name())
 *             .build());
 *     }
 * }
 * ```
 * ### Function Version
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfig;
 * import com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisionedConcurrencyConfig("example", ProvisionedConcurrencyConfigArgs.builder()
 *             .functionName(aws_lambda_function.example().function_name())
 *             .provisionedConcurrentExecutions(1)
 *             .qualifier(aws_lambda_function.example().version())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a Lambda Provisioned Concurrency Configuration using the `function_name` and `qualifier` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:lambda/provisionedConcurrencyConfig:ProvisionedConcurrencyConfig example my_function,production
 * ```
 * @property functionName Name or Amazon Resource Name (ARN) of the Lambda Function.
 * @property provisionedConcurrentExecutions Amount of capacity to allocate. Must be greater than or equal to `1`.
 * @property qualifier Lambda Function version or Lambda Alias name.
 * The following arguments are optional:
 * @property skipDestroy Whether to retain the provisoned concurrency configuration upon destruction. Defaults to `false`. If set to `true`, the resource in simply removed from state instead.
 */
public data class ProvisionedConcurrencyConfigArgs(
    public val functionName: Output<String>? = null,
    public val provisionedConcurrentExecutions: Output<Int>? = null,
    public val qualifier: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs =
        com.pulumi.aws.lambda.ProvisionedConcurrencyConfigArgs.builder()
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .provisionedConcurrentExecutions(provisionedConcurrentExecutions?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProvisionedConcurrencyConfigArgs].
 */
@PulumiTagMarker
public class ProvisionedConcurrencyConfigArgsBuilder internal constructor() {
    private var functionName: Output<String>? = null

    private var provisionedConcurrentExecutions: Output<Int>? = null

    private var qualifier: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    /**
     * @param value Name or Amazon Resource Name (ARN) of the Lambda Function.
     */
    @JvmName("askiaxpbaglbydwb")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Amount of capacity to allocate. Must be greater than or equal to `1`.
     */
    @JvmName("wlfehcdbvtmtjhwn")
    public suspend fun provisionedConcurrentExecutions(`value`: Output<Int>) {
        this.provisionedConcurrentExecutions = value
    }

    /**
     * @param value Lambda Function version or Lambda Alias name.
     * The following arguments are optional:
     */
    @JvmName("pjiyhhjxsylijkoc")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value Whether to retain the provisoned concurrency configuration upon destruction. Defaults to `false`. If set to `true`, the resource in simply removed from state instead.
     */
    @JvmName("ccenxjxcmlemlndt")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value Name or Amazon Resource Name (ARN) of the Lambda Function.
     */
    @JvmName("lmhdyefogvikjqxp")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Amount of capacity to allocate. Must be greater than or equal to `1`.
     */
    @JvmName("rxfbtrcmggbgojbe")
    public suspend fun provisionedConcurrentExecutions(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedConcurrentExecutions = mapped
    }

    /**
     * @param value Lambda Function version or Lambda Alias name.
     * The following arguments are optional:
     */
    @JvmName("sjbdexhldhbdarap")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    /**
     * @param value Whether to retain the provisoned concurrency configuration upon destruction. Defaults to `false`. If set to `true`, the resource in simply removed from state instead.
     */
    @JvmName("acgaoedhvkiqmiqb")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    internal fun build(): ProvisionedConcurrencyConfigArgs = ProvisionedConcurrencyConfigArgs(
        functionName = functionName,
        provisionedConcurrentExecutions = provisionedConcurrentExecutions,
        qualifier = qualifier,
        skipDestroy = skipDestroy,
    )
}
