@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.CodeSigningConfigPoliciesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property untrustedArtifactOnDeployment Code signing configuration policy for deployment validation failure. If you set the policy to Enforce, Lambda blocks the deployment request if code-signing validation checks fail. If you set the policy to Warn, Lambda allows the deployment and creates a CloudWatch log. Valid values: `Warn`, `Enforce`. Default value: `Warn`.
 */
public data class CodeSigningConfigPoliciesArgs(
    public val untrustedArtifactOnDeployment: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.CodeSigningConfigPoliciesArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.CodeSigningConfigPoliciesArgs =
        com.pulumi.aws.lambda.inputs.CodeSigningConfigPoliciesArgs.builder()
            .untrustedArtifactOnDeployment(untrustedArtifactOnDeployment.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CodeSigningConfigPoliciesArgs].
 */
@PulumiTagMarker
public class CodeSigningConfigPoliciesArgsBuilder internal constructor() {
    private var untrustedArtifactOnDeployment: Output<String>? = null

    /**
     * @param value Code signing configuration policy for deployment validation failure. If you set the policy to Enforce, Lambda blocks the deployment request if code-signing validation checks fail. If you set the policy to Warn, Lambda allows the deployment and creates a CloudWatch log. Valid values: `Warn`, `Enforce`. Default value: `Warn`.
     */
    @JvmName("pxpnitmqxgcxejvc")
    public suspend fun untrustedArtifactOnDeployment(`value`: Output<String>) {
        this.untrustedArtifactOnDeployment = value
    }

    /**
     * @param value Code signing configuration policy for deployment validation failure. If you set the policy to Enforce, Lambda blocks the deployment request if code-signing validation checks fail. If you set the policy to Warn, Lambda allows the deployment and creates a CloudWatch log. Valid values: `Warn`, `Enforce`. Default value: `Warn`.
     */
    @JvmName("iogpbxtihbpigcsa")
    public suspend fun untrustedArtifactOnDeployment(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.untrustedArtifactOnDeployment = mapped
    }

    internal fun build(): CodeSigningConfigPoliciesArgs = CodeSigningConfigPoliciesArgs(
        untrustedArtifactOnDeployment = untrustedArtifactOnDeployment ?: throw
            PulumiNullFieldException("untrustedArtifactOnDeployment"),
    )
}
