@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingDestinationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property onFailure The destination configuration for failed invocations. Detailed below.
 */
public data class EventSourceMappingDestinationConfigArgs(
    public val onFailure: Output<EventSourceMappingDestinationConfigOnFailureArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingDestinationConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.EventSourceMappingDestinationConfigArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingDestinationConfigArgs.builder()
            .onFailure(onFailure?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EventSourceMappingDestinationConfigArgs].
 */
@PulumiTagMarker
public class EventSourceMappingDestinationConfigArgsBuilder internal constructor() {
    private var onFailure: Output<EventSourceMappingDestinationConfigOnFailureArgs>? = null

    /**
     * @param value The destination configuration for failed invocations. Detailed below.
     */
    @JvmName("esrinupmtpqpdokj")
    public suspend fun onFailure(`value`: Output<EventSourceMappingDestinationConfigOnFailureArgs>) {
        this.onFailure = value
    }

    /**
     * @param value The destination configuration for failed invocations. Detailed below.
     */
    @JvmName("wlwxrdryuqvyxtqp")
    public suspend fun onFailure(`value`: EventSourceMappingDestinationConfigOnFailureArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onFailure = mapped
    }

    /**
     * @param argument The destination configuration for failed invocations. Detailed below.
     */
    @JvmName("krhrjnjncbyuwsph")
    public suspend
    fun onFailure(argument: suspend EventSourceMappingDestinationConfigOnFailureArgsBuilder.() -> Unit) {
        val toBeMapped = EventSourceMappingDestinationConfigOnFailureArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.onFailure = mapped
    }

    internal fun build(): EventSourceMappingDestinationConfigArgs =
        EventSourceMappingDestinationConfigArgs(
            onFailure = onFailure,
        )
}
