@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingDocumentDbEventSourceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property collectionName The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
 * @property databaseName The name of the database to consume within the DocumentDB cluster.
 * @property fullDocument Determines what DocumentDB sends to your event stream during document update operations. If set to `UpdateLookup`, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes. Valid values: `UpdateLookup`, `Default`.
 */
public data class EventSourceMappingDocumentDbEventSourceConfigArgs(
    public val collectionName: Output<String>? = null,
    public val databaseName: Output<String>,
    public val fullDocument: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingDocumentDbEventSourceConfigArgs> {
    override fun toJava():
        com.pulumi.aws.lambda.inputs.EventSourceMappingDocumentDbEventSourceConfigArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingDocumentDbEventSourceConfigArgs.builder()
            .collectionName(collectionName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .fullDocument(fullDocument?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourceMappingDocumentDbEventSourceConfigArgs].
 */
@PulumiTagMarker
public class EventSourceMappingDocumentDbEventSourceConfigArgsBuilder internal constructor() {
    private var collectionName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var fullDocument: Output<String>? = null

    /**
     * @param value The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
     */
    @JvmName("wutiwlncwrxcahho")
    public suspend fun collectionName(`value`: Output<String>) {
        this.collectionName = value
    }

    /**
     * @param value The name of the database to consume within the DocumentDB cluster.
     */
    @JvmName("gjdopmubjrcqetvn")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Determines what DocumentDB sends to your event stream during document update operations. If set to `UpdateLookup`, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes. Valid values: `UpdateLookup`, `Default`.
     */
    @JvmName("tjtixrlampewfwxo")
    public suspend fun fullDocument(`value`: Output<String>) {
        this.fullDocument = value
    }

    /**
     * @param value The name of the collection to consume within the database. If you do not specify a collection, Lambda consumes all collections.
     */
    @JvmName("hhinorynpuxkkkhv")
    public suspend fun collectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionName = mapped
    }

    /**
     * @param value The name of the database to consume within the DocumentDB cluster.
     */
    @JvmName("dodcdsfmylqwsivi")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Determines what DocumentDB sends to your event stream during document update operations. If set to `UpdateLookup`, DocumentDB sends a delta describing the changes, along with a copy of the entire document. Otherwise, DocumentDB sends only a partial document that contains the changes. Valid values: `UpdateLookup`, `Default`.
     */
    @JvmName("tkcewxfdhexbphrs")
    public suspend fun fullDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fullDocument = mapped
    }

    internal fun build(): EventSourceMappingDocumentDbEventSourceConfigArgs =
        EventSourceMappingDocumentDbEventSourceConfigArgs(
            collectionName = collectionName,
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            fullDocument = fullDocument,
        )
}
