@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property filters A set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. Detailed below.
 */
public data class EventSourceMappingFilterCriteriaArgs(
    public val filters: Output<List<EventSourceMappingFilterCriteriaFilterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaArgs.builder()
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventSourceMappingFilterCriteriaArgs].
 */
@PulumiTagMarker
public class EventSourceMappingFilterCriteriaArgsBuilder internal constructor() {
    private var filters: Output<List<EventSourceMappingFilterCriteriaFilterArgs>>? = null

    /**
     * @param value A set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. Detailed below.
     */
    @JvmName("gefauulebntwyhiu")
    public suspend fun filters(`value`: Output<List<EventSourceMappingFilterCriteriaFilterArgs>>) {
        this.filters = value
    }

    @JvmName("fdbxuekcspisdbss")
    public suspend fun filters(vararg values: Output<EventSourceMappingFilterCriteriaFilterArgs>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values A set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. Detailed below.
     */
    @JvmName("ewbmiahswbhxbxdl")
    public suspend fun filters(values: List<Output<EventSourceMappingFilterCriteriaFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value A set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. Detailed below.
     */
    @JvmName("ilpbpjopxapwtdbq")
    public suspend fun filters(`value`: List<EventSourceMappingFilterCriteriaFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument A set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. Detailed below.
     */
    @JvmName("ygkofglsrnkboqwp")
    public suspend
    fun filters(argument: List<suspend EventSourceMappingFilterCriteriaFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventSourceMappingFilterCriteriaFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument A set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. Detailed below.
     */
    @JvmName("saiskkavngyuwvxd")
    public suspend fun filters(
        vararg
        argument: suspend EventSourceMappingFilterCriteriaFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EventSourceMappingFilterCriteriaFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument A set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. Detailed below.
     */
    @JvmName("uhxrtsdjhxmpcbhl")
    public suspend
    fun filters(argument: suspend EventSourceMappingFilterCriteriaFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventSourceMappingFilterCriteriaFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values A set of up to 5 filter. If an event satisfies at least one, Lambda sends the event to the function or adds it to the next batch. Detailed below.
     */
    @JvmName("oajsrtmhqtitqfcf")
    public suspend fun filters(vararg values: EventSourceMappingFilterCriteriaFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    internal fun build(): EventSourceMappingFilterCriteriaArgs = EventSourceMappingFilterCriteriaArgs(
        filters = filters,
    )
}
