@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property pattern A filter pattern up to 4096 characters. See [Filter Rule Syntax](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax).
 */
public data class EventSourceMappingFilterCriteriaFilterArgs(
    public val pattern: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaFilterArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaFilterArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingFilterCriteriaFilterArgs.builder()
            .pattern(pattern?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourceMappingFilterCriteriaFilterArgs].
 */
@PulumiTagMarker
public class EventSourceMappingFilterCriteriaFilterArgsBuilder internal constructor() {
    private var pattern: Output<String>? = null

    /**
     * @param value A filter pattern up to 4096 characters. See [Filter Rule Syntax](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax).
     */
    @JvmName("obsmrnsukelqwilq")
    public suspend fun pattern(`value`: Output<String>) {
        this.pattern = value
    }

    /**
     * @param value A filter pattern up to 4096 characters. See [Filter Rule Syntax](https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-syntax).
     */
    @JvmName("spftgiqwalposapr")
    public suspend fun pattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    internal fun build(): EventSourceMappingFilterCriteriaFilterArgs =
        EventSourceMappingFilterCriteriaFilterArgs(
            pattern = pattern,
        )
}
