@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingScalingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumConcurrency Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be between `2` and `1000`. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
 */
public data class EventSourceMappingScalingConfigArgs(
    public val maximumConcurrency: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingScalingConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.EventSourceMappingScalingConfigArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingScalingConfigArgs.builder()
            .maximumConcurrency(maximumConcurrency?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourceMappingScalingConfigArgs].
 */
@PulumiTagMarker
public class EventSourceMappingScalingConfigArgsBuilder internal constructor() {
    private var maximumConcurrency: Output<Int>? = null

    /**
     * @param value Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be between `2` and `1000`. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
     */
    @JvmName("xcdmatrvwcdmdfnj")
    public suspend fun maximumConcurrency(`value`: Output<Int>) {
        this.maximumConcurrency = value
    }

    /**
     * @param value Limits the number of concurrent instances that the Amazon SQS event source can invoke. Must be between `2` and `1000`. See [Configuring maximum concurrency for Amazon SQS event sources](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency).
     */
    @JvmName("aykyoywfmytyieml")
    public suspend fun maximumConcurrency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumConcurrency = mapped
    }

    internal fun build(): EventSourceMappingScalingConfigArgs = EventSourceMappingScalingConfigArgs(
        maximumConcurrency = maximumConcurrency,
    )
}
