@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedKafkaEventSourceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property consumerGroupId A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [SelfManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_SelfManagedKafkaEventSourceConfig.html).
 */
public data class EventSourceMappingSelfManagedKafkaEventSourceConfigArgs(
    public val consumerGroupId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedKafkaEventSourceConfigArgs> {
    override fun toJava():
        com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedKafkaEventSourceConfigArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingSelfManagedKafkaEventSourceConfigArgs.builder()
            .consumerGroupId(consumerGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourceMappingSelfManagedKafkaEventSourceConfigArgs].
 */
@PulumiTagMarker
public class EventSourceMappingSelfManagedKafkaEventSourceConfigArgsBuilder internal constructor() {
    private var consumerGroupId: Output<String>? = null

    /**
     * @param value A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [SelfManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_SelfManagedKafkaEventSourceConfig.html).
     */
    @JvmName("urboqxfnfjqxilkk")
    public suspend fun consumerGroupId(`value`: Output<String>) {
        this.consumerGroupId = value
    }

    /**
     * @param value A Kafka consumer group ID between 1 and 200 characters for use when creating this event source mapping. If one is not specified, this value will be automatically generated. See [SelfManagedKafkaEventSourceConfig Syntax](https://docs.aws.amazon.com/lambda/latest/dg/API_SelfManagedKafkaEventSourceConfig.html).
     */
    @JvmName("ytwvooecwfwtbslv")
    public suspend fun consumerGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroupId = mapped
    }

    internal fun build(): EventSourceMappingSelfManagedKafkaEventSourceConfigArgs =
        EventSourceMappingSelfManagedKafkaEventSourceConfigArgs(
            consumerGroupId = consumerGroupId,
        )
}
