@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The type of this configuration.  For Self Managed Kafka you will need to supply blocks for type `VPC_SUBNET` and `VPC_SECURITY_GROUP`.
 * @property uri The URI for this configuration.  For type `VPC_SUBNET` the value should be `subnet:subnet_id` where `subnet_id` is the value you would find in an aws.ec2.Subnet resource's id attribute.  For type `VPC_SECURITY_GROUP` the value should be `security_group:security_group_id` where `security_group_id` is the value you would find in an aws.ec2.SecurityGroup resource's id attribute.
 */
public data class EventSourceMappingSourceAccessConfigurationArgs(
    public val type: Output<String>,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs =
        com.pulumi.aws.lambda.inputs.EventSourceMappingSourceAccessConfigurationArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourceMappingSourceAccessConfigurationArgs].
 */
@PulumiTagMarker
public class EventSourceMappingSourceAccessConfigurationArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The type of this configuration.  For Self Managed Kafka you will need to supply blocks for type `VPC_SUBNET` and `VPC_SECURITY_GROUP`.
     */
    @JvmName("tutrwbaunqrxyotm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The URI for this configuration.  For type `VPC_SUBNET` the value should be `subnet:subnet_id` where `subnet_id` is the value you would find in an aws.ec2.Subnet resource's id attribute.  For type `VPC_SECURITY_GROUP` the value should be `security_group:security_group_id` where `security_group_id` is the value you would find in an aws.ec2.SecurityGroup resource's id attribute.
     */
    @JvmName("kmvomytbrdmjwqtq")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The type of this configuration.  For Self Managed Kafka you will need to supply blocks for type `VPC_SUBNET` and `VPC_SECURITY_GROUP`.
     */
    @JvmName("rddtcdqbkvghndjn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The URI for this configuration.  For type `VPC_SUBNET` the value should be `subnet:subnet_id` where `subnet_id` is the value you would find in an aws.ec2.Subnet resource's id attribute.  For type `VPC_SECURITY_GROUP` the value should be `security_group:security_group_id` where `security_group_id` is the value you would find in an aws.ec2.SecurityGroup resource's id attribute.
     */
    @JvmName("ialwworudvbhnbfc")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): EventSourceMappingSourceAccessConfigurationArgs =
        EventSourceMappingSourceAccessConfigurationArgs(
            type = type ?: throw PulumiNullFieldException("type"),
            uri = uri ?: throw PulumiNullFieldException("uri"),
        )
}
