@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionEphemeralStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property size The size of the Lambda function Ephemeral storage(`/tmp`) represented in MB. The minimum supported `ephemeral_storage` value defaults to `512`MB and the maximum supported value is `10240`MB.
 */
public data class FunctionEphemeralStorageArgs(
    public val size: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionEphemeralStorageArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionEphemeralStorageArgs =
        com.pulumi.aws.lambda.inputs.FunctionEphemeralStorageArgs.builder()
            .size(size?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionEphemeralStorageArgs].
 */
@PulumiTagMarker
public class FunctionEphemeralStorageArgsBuilder internal constructor() {
    private var size: Output<Int>? = null

    /**
     * @param value The size of the Lambda function Ephemeral storage(`/tmp`) represented in MB. The minimum supported `ephemeral_storage` value defaults to `512`MB and the maximum supported value is `10240`MB.
     */
    @JvmName("ginrfrycihytkrgr")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The size of the Lambda function Ephemeral storage(`/tmp`) represented in MB. The minimum supported `ephemeral_storage` value defaults to `512`MB and the maximum supported value is `10240`MB.
     */
    @JvmName("iwwxskbfmehkvywu")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): FunctionEphemeralStorageArgs = FunctionEphemeralStorageArgs(
        size = size,
    )
}
