@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionFileSystemConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
 * @property localMountPath Path where the function can access the file system, starting with /mnt/.
 */
public data class FunctionFileSystemConfigArgs(
    public val arn: Output<String>,
    public val localMountPath: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionFileSystemConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionFileSystemConfigArgs =
        com.pulumi.aws.lambda.inputs.FunctionFileSystemConfigArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .localMountPath(localMountPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionFileSystemConfigArgs].
 */
@PulumiTagMarker
public class FunctionFileSystemConfigArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var localMountPath: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
     */
    @JvmName("iboehbkgjaijamwi")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Path where the function can access the file system, starting with /mnt/.
     */
    @JvmName("mwmfqgnmcffkkwru")
    public suspend fun localMountPath(`value`: Output<String>) {
        this.localMountPath = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Amazon EFS Access Point that provides access to the file system.
     */
    @JvmName("mnkgnfhqpqwvvqjx")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Path where the function can access the file system, starting with /mnt/.
     */
    @JvmName("mkeqfjltrpmdksxx")
    public suspend fun localMountPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localMountPath = mapped
    }

    internal fun build(): FunctionFileSystemConfigArgs = FunctionFileSystemConfigArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        localMountPath = localMountPath ?: throw PulumiNullFieldException("localMountPath"),
    )
}
