@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionImageConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property commands Parameters that you want to pass in with `entry_point`.
 * @property entryPoints Entry point to your application, which is typically the location of the runtime executable.
 * @property workingDirectory Working directory.
 */
public data class FunctionImageConfigArgs(
    public val commands: Output<List<String>>? = null,
    public val entryPoints: Output<List<String>>? = null,
    public val workingDirectory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionImageConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionImageConfigArgs =
        com.pulumi.aws.lambda.inputs.FunctionImageConfigArgs.builder()
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .entryPoints(entryPoints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .workingDirectory(workingDirectory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionImageConfigArgs].
 */
@PulumiTagMarker
public class FunctionImageConfigArgsBuilder internal constructor() {
    private var commands: Output<List<String>>? = null

    private var entryPoints: Output<List<String>>? = null

    private var workingDirectory: Output<String>? = null

    /**
     * @param value Parameters that you want to pass in with `entry_point`.
     */
    @JvmName("aqjekpqqiwcxoino")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("idqvqeixoljuipxy")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values Parameters that you want to pass in with `entry_point`.
     */
    @JvmName("scaiioxxfolhgbcp")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value Entry point to your application, which is typically the location of the runtime executable.
     */
    @JvmName("itmxajgnueqpjhqq")
    public suspend fun entryPoints(`value`: Output<List<String>>) {
        this.entryPoints = value
    }

    @JvmName("mnlanjcpetxwuiuh")
    public suspend fun entryPoints(vararg values: Output<String>) {
        this.entryPoints = Output.all(values.asList())
    }

    /**
     * @param values Entry point to your application, which is typically the location of the runtime executable.
     */
    @JvmName("tdyhibafdetnwhrj")
    public suspend fun entryPoints(values: List<Output<String>>) {
        this.entryPoints = Output.all(values)
    }

    /**
     * @param value Working directory.
     */
    @JvmName("okwgswgbsqluhrpe")
    public suspend fun workingDirectory(`value`: Output<String>) {
        this.workingDirectory = value
    }

    /**
     * @param value Parameters that you want to pass in with `entry_point`.
     */
    @JvmName("chjsaijwhtsegllv")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values Parameters that you want to pass in with `entry_point`.
     */
    @JvmName("rqcdhpdbgbvdihkt")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value Entry point to your application, which is typically the location of the runtime executable.
     */
    @JvmName("eekxnddrdvcegkpe")
    public suspend fun entryPoints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entryPoints = mapped
    }

    /**
     * @param values Entry point to your application, which is typically the location of the runtime executable.
     */
    @JvmName("kxxslskflglvasxu")
    public suspend fun entryPoints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entryPoints = mapped
    }

    /**
     * @param value Working directory.
     */
    @JvmName("aebojwtmfxkqpkve")
    public suspend fun workingDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workingDirectory = mapped
    }

    internal fun build(): FunctionImageConfigArgs = FunctionImageConfigArgs(
        commands = commands,
        entryPoints = entryPoints,
        workingDirectory = workingDirectory,
    )
}
