@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionUrlCorsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowCredentials Whether to allow cookies or other credentials in requests to the function URL. The default is `false`.
 * @property allowHeaders The HTTP headers that origins can include in requests to the function URL. For example: `["date", "keep-alive", "x-custom-header"]`.
 * @property allowMethods The HTTP methods that are allowed when calling the function URL. For example: `["GET", "POST", "DELETE"]`, or the wildcard character (`["*"]`).
 * @property allowOrigins The origins that can access the function URL. You can list any number of specific origins (or the wildcard character (`"*"`)), separated by a comma. For example: `["https://www&#46;example&#46;com", "http://localhost:60905"]`.
 * @property exposeHeaders The HTTP headers in your function response that you want to expose to origins that call the function URL.
 * @property maxAge The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By default, this is set to `0`, which means that the browser doesn't cache results. The maximum value is `86400`.
 */
public data class FunctionUrlCorsArgs(
    public val allowCredentials: Output<Boolean>? = null,
    public val allowHeaders: Output<List<String>>? = null,
    public val allowMethods: Output<List<String>>? = null,
    public val allowOrigins: Output<List<String>>? = null,
    public val exposeHeaders: Output<List<String>>? = null,
    public val maxAge: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionUrlCorsArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionUrlCorsArgs =
        com.pulumi.aws.lambda.inputs.FunctionUrlCorsArgs.builder()
            .allowCredentials(allowCredentials?.applyValue({ args0 -> args0 }))
            .allowHeaders(allowHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowMethods(allowMethods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowOrigins(allowOrigins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposeHeaders(exposeHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAge(maxAge?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionUrlCorsArgs].
 */
@PulumiTagMarker
public class FunctionUrlCorsArgsBuilder internal constructor() {
    private var allowCredentials: Output<Boolean>? = null

    private var allowHeaders: Output<List<String>>? = null

    private var allowMethods: Output<List<String>>? = null

    private var allowOrigins: Output<List<String>>? = null

    private var exposeHeaders: Output<List<String>>? = null

    private var maxAge: Output<Int>? = null

    /**
     * @param value Whether to allow cookies or other credentials in requests to the function URL. The default is `false`.
     */
    @JvmName("mkehvmcpuvokgbdj")
    public suspend fun allowCredentials(`value`: Output<Boolean>) {
        this.allowCredentials = value
    }

    /**
     * @param value The HTTP headers that origins can include in requests to the function URL. For example: `["date", "keep-alive", "x-custom-header"]`.
     */
    @JvmName("gttooipbhpbctewx")
    public suspend fun allowHeaders(`value`: Output<List<String>>) {
        this.allowHeaders = value
    }

    @JvmName("cmxqpdomdybugfnh")
    public suspend fun allowHeaders(vararg values: Output<String>) {
        this.allowHeaders = Output.all(values.asList())
    }

    /**
     * @param values The HTTP headers that origins can include in requests to the function URL. For example: `["date", "keep-alive", "x-custom-header"]`.
     */
    @JvmName("mdtrkenvwsrcyyag")
    public suspend fun allowHeaders(values: List<Output<String>>) {
        this.allowHeaders = Output.all(values)
    }

    /**
     * @param value The HTTP methods that are allowed when calling the function URL. For example: `["GET", "POST", "DELETE"]`, or the wildcard character (`["*"]`).
     */
    @JvmName("dpdkhcoagiavtvoy")
    public suspend fun allowMethods(`value`: Output<List<String>>) {
        this.allowMethods = value
    }

    @JvmName("ixoowbnvhsnwbfcg")
    public suspend fun allowMethods(vararg values: Output<String>) {
        this.allowMethods = Output.all(values.asList())
    }

    /**
     * @param values The HTTP methods that are allowed when calling the function URL. For example: `["GET", "POST", "DELETE"]`, or the wildcard character (`["*"]`).
     */
    @JvmName("rmobsebgbtsoatqd")
    public suspend fun allowMethods(values: List<Output<String>>) {
        this.allowMethods = Output.all(values)
    }

    /**
     * @param value The origins that can access the function URL. You can list any number of specific origins (or the wildcard character (`"*"`)), separated by a comma. For example: `["https://www&#46;example&#46;com", "http://localhost:60905"]`.
     */
    @JvmName("fgsyheegmuoitwkk")
    public suspend fun allowOrigins(`value`: Output<List<String>>) {
        this.allowOrigins = value
    }

    @JvmName("xhmbamnudgwfearh")
    public suspend fun allowOrigins(vararg values: Output<String>) {
        this.allowOrigins = Output.all(values.asList())
    }

    /**
     * @param values The origins that can access the function URL. You can list any number of specific origins (or the wildcard character (`"*"`)), separated by a comma. For example: `["https://www&#46;example&#46;com", "http://localhost:60905"]`.
     */
    @JvmName("dcbyhtqdbxwlcxyr")
    public suspend fun allowOrigins(values: List<Output<String>>) {
        this.allowOrigins = Output.all(values)
    }

    /**
     * @param value The HTTP headers in your function response that you want to expose to origins that call the function URL.
     */
    @JvmName("tmlvyoulgeknlfho")
    public suspend fun exposeHeaders(`value`: Output<List<String>>) {
        this.exposeHeaders = value
    }

    @JvmName("jtohvaegwbalumsr")
    public suspend fun exposeHeaders(vararg values: Output<String>) {
        this.exposeHeaders = Output.all(values.asList())
    }

    /**
     * @param values The HTTP headers in your function response that you want to expose to origins that call the function URL.
     */
    @JvmName("kilaodmnrvcuosgk")
    public suspend fun exposeHeaders(values: List<Output<String>>) {
        this.exposeHeaders = Output.all(values)
    }

    /**
     * @param value The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By default, this is set to `0`, which means that the browser doesn't cache results. The maximum value is `86400`.
     */
    @JvmName("frejkwndysefhjib")
    public suspend fun maxAge(`value`: Output<Int>) {
        this.maxAge = value
    }

    /**
     * @param value Whether to allow cookies or other credentials in requests to the function URL. The default is `false`.
     */
    @JvmName("oegasloadygvpbne")
    public suspend fun allowCredentials(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCredentials = mapped
    }

    /**
     * @param value The HTTP headers that origins can include in requests to the function URL. For example: `["date", "keep-alive", "x-custom-header"]`.
     */
    @JvmName("dmivgrxjoqpiwmlw")
    public suspend fun allowHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowHeaders = mapped
    }

    /**
     * @param values The HTTP headers that origins can include in requests to the function URL. For example: `["date", "keep-alive", "x-custom-header"]`.
     */
    @JvmName("uyhchckivultupnm")
    public suspend fun allowHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowHeaders = mapped
    }

    /**
     * @param value The HTTP methods that are allowed when calling the function URL. For example: `["GET", "POST", "DELETE"]`, or the wildcard character (`["*"]`).
     */
    @JvmName("sofcdgsepvspcald")
    public suspend fun allowMethods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMethods = mapped
    }

    /**
     * @param values The HTTP methods that are allowed when calling the function URL. For example: `["GET", "POST", "DELETE"]`, or the wildcard character (`["*"]`).
     */
    @JvmName("hhealtjltiyxvxhp")
    public suspend fun allowMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowMethods = mapped
    }

    /**
     * @param value The origins that can access the function URL. You can list any number of specific origins (or the wildcard character (`"*"`)), separated by a comma. For example: `["https://www&#46;example&#46;com", "http://localhost:60905"]`.
     */
    @JvmName("vwgfnuaakcfmquui")
    public suspend fun allowOrigins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowOrigins = mapped
    }

    /**
     * @param values The origins that can access the function URL. You can list any number of specific origins (or the wildcard character (`"*"`)), separated by a comma. For example: `["https://www&#46;example&#46;com", "http://localhost:60905"]`.
     */
    @JvmName("gtsfejprjjntewyd")
    public suspend fun allowOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowOrigins = mapped
    }

    /**
     * @param value The HTTP headers in your function response that you want to expose to origins that call the function URL.
     */
    @JvmName("dvmrhahwvlnuxlxj")
    public suspend fun exposeHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param values The HTTP headers in your function response that you want to expose to origins that call the function URL.
     */
    @JvmName("ehhyfxjicioietuj")
    public suspend fun exposeHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param value The maximum amount of time, in seconds, that web browsers can cache results of a preflight request. By default, this is set to `0`, which means that the browser doesn't cache results. The maximum value is `86400`.
     */
    @JvmName("unkjuxfwvtxmpyvq")
    public suspend fun maxAge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAge = mapped
    }

    internal fun build(): FunctionUrlCorsArgs = FunctionUrlCorsArgs(
        allowCredentials = allowCredentials,
        allowHeaders = allowHeaders,
        allowMethods = allowMethods,
        allowOrigins = allowOrigins,
        exposeHeaders = exposeHeaders,
        maxAge = maxAge,
    )
}
