@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lambda.kotlin.inputs

import com.pulumi.aws.lambda.inputs.FunctionVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ipv6AllowedForDualStack Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets. Default is `false`.
 * @property securityGroupIds List of security group IDs associated with the Lambda function.
 * @property subnetIds List of subnet IDs associated with the Lambda function.
 * @property vpcId
 */
public data class FunctionVpcConfigArgs(
    public val ipv6AllowedForDualStack: Output<Boolean>? = null,
    public val securityGroupIds: Output<List<String>>,
    public val subnetIds: Output<List<String>>,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lambda.inputs.FunctionVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.lambda.inputs.FunctionVpcConfigArgs =
        com.pulumi.aws.lambda.inputs.FunctionVpcConfigArgs.builder()
            .ipv6AllowedForDualStack(ipv6AllowedForDualStack?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionVpcConfigArgs].
 */
@PulumiTagMarker
public class FunctionVpcConfigArgsBuilder internal constructor() {
    private var ipv6AllowedForDualStack: Output<Boolean>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets. Default is `false`.
     */
    @JvmName("gnmtjkcghdlbuwpg")
    public suspend fun ipv6AllowedForDualStack(`value`: Output<Boolean>) {
        this.ipv6AllowedForDualStack = value
    }

    /**
     * @param value List of security group IDs associated with the Lambda function.
     */
    @JvmName("fmawcavjkwuwjtei")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("owexysqvaltcnedj")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of security group IDs associated with the Lambda function.
     */
    @JvmName("kokrvitbdytuwqxa")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value List of subnet IDs associated with the Lambda function.
     */
    @JvmName("qjxbaicevkugnkcm")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("whpympvfuahyvcam")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values List of subnet IDs associated with the Lambda function.
     */
    @JvmName("buahroyavypsvnra")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gqlledyljyjruwxp")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Allows outbound IPv6 traffic on VPC functions that are connected to dual-stack subnets. Default is `false`.
     */
    @JvmName("lfvrsfoelewwnyfy")
    public suspend fun ipv6AllowedForDualStack(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AllowedForDualStack = mapped
    }

    /**
     * @param value List of security group IDs associated with the Lambda function.
     */
    @JvmName("oxyyyoduictbqxqe")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values List of security group IDs associated with the Lambda function.
     */
    @JvmName("xuxolowshiyhlsub")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value List of subnet IDs associated with the Lambda function.
     */
    @JvmName("kiyvhgiiduxfyuor")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values List of subnet IDs associated with the Lambda function.
     */
    @JvmName("udgawthuylrqjhfb")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("mxdnvccnrcoxywyh")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): FunctionVpcConfigArgs = FunctionVpcConfigArgs(
        ipv6AllowedForDualStack = ipv6AllowedForDualStack,
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
        vpcId = vpcId,
    )
}
